/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.calendar.api.IVEvent.
 */
namespace net.bluemind.calendar.api
{

  public class VEventClient : BMClient
  {
    private String containerUid;
  
    /*
     * Constructor 
     */
    public VEventClient(String baseUrl, String sid , String containerUid )
    {
      this.baseUrl = baseUrl + "/api/calendars/vevent/{containerUid}";      
      this.sid = sid;
      this.containerUid = containerUid;
      this.baseUrl = this.baseUrl.Replace("{containerUid}", containerUid);
      this.logger = new DefaultLogger();
      this.version = "5.5.3184";
    }
    
    public Stream exportAll()
    {
      String methodVerb = "GET";
      String methodPathValue = "";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<Stream>(methodPathValue, queryParams, body, methodVerb);
    }
    public String exportIcs(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<String>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskRef importIcs(Stream ics )
    {
      String methodVerb = "PUT";
      String methodPathValue = "";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      body = ics;
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
