/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.calendar.api.IPublishCalendar.
 */
namespace net.bluemind.calendar.api
{

  public class PublishCalendarClient : BMClient
  {
    private String containerUid;
  
    /*
     * Constructor 
     */
    public PublishCalendarClient(String baseUrl, String sid , String containerUid )
    {
      this.baseUrl = baseUrl + "/api/calendars/publish/{containerUid}";      
      this.sid = sid;
      this.containerUid = containerUid;
      this.baseUrl = this.baseUrl.Replace("{containerUid}", containerUid);
      this.logger = new DefaultLogger();
      this.version = "5.5.3184";
    }
    
    public String createUrl(net.bluemind.calendar.api.PublishMode mode, String token )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/_create/{mode}";
      methodPathValue = methodPathValue.Replace("{mode}", HttpUtility.UrlEncode("" + mode));

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("token", token.ToString());

      dynamic body = null;
      return this.execute<String>(methodPathValue, queryParams, body, methodVerb);
    }
    public void disableUrl(String url )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_disable";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(String));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, url);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public String generateUrl(net.bluemind.calendar.api.PublishMode mode )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/_generate/{mode}";
      methodPathValue = methodPathValue.Replace("{mode}", HttpUtility.UrlEncode("" + mode));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<String>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<String> getGeneratedUrls(net.bluemind.calendar.api.PublishMode mode )
    {
      String methodVerb = "GET";
      String methodPathValue = "/generated/{mode}";
      methodPathValue = methodPathValue.Replace("{mode}", HttpUtility.UrlEncode("" + mode));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public Stream publish(String token )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{token}";
      methodPathValue = methodPathValue.Replace("{token}", HttpUtility.UrlEncode("" + token));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<Stream>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
