/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.calendar.api.ICalendars.
 */
namespace net.bluemind.calendar.api
{

  public class CalendarsClient : BMClient
  {
  
    /*
     * Constructor 
     */
    public CalendarsClient(String baseUrl, String sid )
    {
      this.baseUrl = baseUrl + "/api/calendars";      
      this.sid = sid;
      this.logger = new DefaultLogger();
      this.version = "5.5.3184";
    }
    
    public List<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.calendar.api.VEventSeries>> multipleGetByRange(net.bluemind.calendar.api.CalendarsVEventRange range )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_mget_range";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.calendar.api.CalendarsVEventRange));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, range);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.calendar.api.VEventSeries>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.calendar.api.VEventSeries>> search(net.bluemind.calendar.api.CalendarsVEventQuery query )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_search";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.calendar.api.CalendarsVEventQuery));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, query);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.calendar.api.VEventSeries>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.calendar.api.VEventSeries>> searchPendingCounters(List<String> calendars )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_search_counters";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, calendars);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.calendar.api.VEventSeries>>>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
