/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.backend.mail.api.IUserInbox.
 */
namespace net.bluemind.backend.mail.api
{

  public class UserInboxClient : BMClient
  {
    private String domainUid;
    private String userUid;
  
    /*
     * Constructor 
     */
    public UserInboxClient(String baseUrl, String sid , String domainUid , String userUid )
    {
      this.baseUrl = baseUrl + "/api/inbox/{domainUid}/{userUid}";      
      this.sid = sid;
      this.domainUid = domainUid;
      this.baseUrl = this.baseUrl.Replace("{domainUid}", domainUid);
      this.userUid = userUid;
      this.baseUrl = this.baseUrl.Replace("{userUid}", userUid);
      this.logger = new DefaultLogger();
      this.version = "5.5.3184";
    }
    
    public int? unseen()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_unseen";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<int?>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
