/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.backend.mail.api
{
  [DataContract(Namespace="")]
  public partial class SearchQuery  {
    [DataMember]
    public String searchSessionId;
    
    [DataMember]
    public String query;
    
    [DataMember]
    public String recordQuery;
    
    [DataMember]
    public String messageId;
    
    [DataMember]
    public String references;
    
    [DataMember]
    public net.bluemind.backend.mail.api.SearchQueryHeaderQuery headerQuery = new net.bluemind.backend.mail.api.SearchQueryHeaderQuery();
    
    [DataMember]
    public long? maxResults;
    
    [DataMember]
    public long? offset;
    
    [DataMember]
    public net.bluemind.backend.mail.api.SearchQuerySearchScope scope = new net.bluemind.backend.mail.api.SearchQuerySearchScope();
    
    [IgnoreDataMember]
    public net.bluemind.backend.mail.api.SearchQueryLogicalOperator? logicalOperator;
    [DataMember(Name = "logicalOperator")]
    public String logicalOperatorSurrogate
    {
        get
        {
            return logicalOperator.HasValue ? logicalOperator.ToString() : null;
        }
        set
        {
            net.bluemind.backend.mail.api.SearchQueryLogicalOperator e;
            logicalOperator = Enum.TryParse(value, true, out e) ? e : (net.bluemind.backend.mail.api.SearchQueryLogicalOperator?)null;
        }
    }
    
    [DataMember]
    public Boolean trackScores;
    
  
  }
}
