/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.backend.mail.api.IMailboxItems.
 */
namespace net.bluemind.backend.mail.api
{

  public class MailboxItemsClient : BMClient
  {
    private String replicatedMailboxUid;
  
    /*
     * Constructor 
     */
    public MailboxItemsClient(String baseUrl, String sid , String replicatedMailboxUid )
    {
      this.baseUrl = baseUrl + "/api/mail_items/{replicatedMailboxUid}";      
      this.sid = sid;
      this.replicatedMailboxUid = replicatedMailboxUid;
      this.baseUrl = this.baseUrl.Replace("{replicatedMailboxUid}", replicatedMailboxUid);
      this.logger = new DefaultLogger();
      this.version = "5.5.3184";
    }
    
    public net.bluemind.core.container.api.Ack addFlag(net.bluemind.backend.mail.api.flags.FlagUpdate flagUpdate )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/_addFlag";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.backend.mail.api.flags.FlagUpdate));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, flagUpdate);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.container.api.Ack>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ContainerChangeset<String> changeset(long? since )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_changeset";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("since", since.ToString());

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ContainerChangeset<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ContainerChangeset<long?> changesetById(long? since )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_changesetById";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("since", since.ToString());

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ContainerChangeset<long?>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.api.Count count(net.bluemind.core.container.model.ItemFlagFilter arg0 )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_count";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.core.container.model.ItemFlagFilter));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg0);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.container.api.Count>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.backend.mail.api.ImapItemIdentifier create(net.bluemind.backend.mail.api.MailboxItem value )
    {
      String methodVerb = "PUT";
      String methodPathValue = "";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.backend.mail.api.MailboxItem));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, value);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.backend.mail.api.ImapItemIdentifier>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.api.Ack createById(long? id, net.bluemind.backend.mail.api.MailboxItem arg1 )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/id/{id}";
      methodPathValue = methodPathValue.Replace("{id}", HttpUtility.UrlEncode("" + id));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.backend.mail.api.MailboxItem));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg1);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.container.api.Ack>(methodPathValue, queryParams, body, methodVerb);
    }
    public void deleteById(long? id )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/id/{id}";
      methodPathValue = methodPathValue.Replace("{id}", HttpUtility.UrlEncode("" + id));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.api.Ack deleteFlag(net.bluemind.backend.mail.api.flags.FlagUpdate flagUpdate )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_deleteFlag";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.backend.mail.api.flags.FlagUpdate));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, flagUpdate);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.container.api.Ack>(methodPathValue, queryParams, body, methodVerb);
    }
    public void expunge()
    {
      String methodVerb = "POST";
      String methodPathValue = "/_expunge";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public Stream fetch(long? imapUid, String address, String encoding, String mime, String charset, String filename )
    {
      String methodVerb = "GET";
      String methodPathValue = "/part/{imapUid}/{address}";
      methodPathValue = methodPathValue.Replace("{imapUid}", HttpUtility.UrlEncode("" + imapUid));
      methodPathValue = methodPathValue.Replace("{address}", HttpUtility.UrlEncode("" + address));

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("encoding", encoding.ToString());
      queryParams.Add("mime", mime.ToString());
      queryParams.Add("charset", charset.ToString());
      queryParams.Add("filename", filename.ToString());

      dynamic body = null;
      return this.execute<Stream>(methodPathValue, queryParams, body, methodVerb);
    }
    public Stream fetchComplete(long? imapUid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/eml/{imapUid}";
      methodPathValue = methodPathValue.Replace("{imapUid}", HttpUtility.UrlEncode("" + imapUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<Stream>(methodPathValue, queryParams, body, methodVerb);
    }
    public Stream fetchCompleteByGuid(String guid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/eml_by_guid/{guid}";
      methodPathValue = methodPathValue.Replace("{guid}", HttpUtility.UrlEncode("" + guid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<Stream>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion> filteredChangesetById(long? since, net.bluemind.core.container.model.ItemFlagFilter arg1 )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_filteredChangesetById";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("since", since.ToString());

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.core.container.model.ItemFlagFilter));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg1);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem> getCompleteById(long? id )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{id}/completeById";
      methodPathValue = methodPathValue.Replace("{id}", HttpUtility.UrlEncode("" + id));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem> getForUpdate(long? id )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{id}/getForUpdate";
      methodPathValue = methodPathValue.Replace("{id}", HttpUtility.UrlEncode("" + id));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem>>(methodPathValue, queryParams, body, methodVerb);
    }
    public long? getVersion()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_version";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<long?>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemChangelog itemChangelog(String uid, long? arg1 )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/_itemchangelog";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(long?));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg1);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.container.model.ItemChangelog>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<long?> listItemIdsAfter(net.bluemind.core.api.date.BmDateTime before )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_list_after_date";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.core.api.date.BmDateTime));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, before);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<long?>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void multipleDeleteById(List<long?> arg0, Boolean? bypassDeletedItems )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/_multipleDelete";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("bypassDeletedItems", bypassDeletedItems.ToString());

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<long?>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg0);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem>> multipleGetById(List<long?> arg0 )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_mgetById";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<long?>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg0);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ItemIdentifier> multipleUnexpungeById(List<long?> itemIds )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_multipleUnexpunge";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<long?>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, itemIds);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.core.container.model.ItemIdentifier>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<long?> recentItems(System.DateTime? deliveredOrUpdatedAfter )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_recent";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(System.DateTime?));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, deliveredOrUpdatedAfter);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<long?>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void removePart(String partId )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/{partId}/_part";
      methodPathValue = methodPathValue.Replace("{partId}", HttpUtility.UrlEncode("" + partId));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<long?> sortedIds(net.bluemind.core.container.model.SortDescriptor arg0 )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_sorted";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.core.container.model.SortDescriptor));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg0);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<long?>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<String> sortedUids(net.bluemind.core.container.model.SortDescriptor arg0 )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_sorteduids";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.core.container.model.SortDescriptor));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg0);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemIdentifier unexpunge(long? itemId )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_unexpunge/{itemId}";
      methodPathValue = methodPathValue.Replace("{itemId}", HttpUtility.UrlEncode("" + itemId));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemIdentifier>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<long?> unreadItems()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_unread";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<long?>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.api.Ack updateById(long? id, net.bluemind.backend.mail.api.MailboxItem arg1 )
    {
      String methodVerb = "POST";
      String methodPathValue = "/id/{id}";
      methodPathValue = methodPathValue.Replace("{id}", HttpUtility.UrlEncode("" + id));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.backend.mail.api.MailboxItem));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg1);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.container.api.Ack>(methodPathValue, queryParams, body, methodVerb);
    }
    public String uploadPart(Stream part )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/_part";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      body = part;
      return this.execute<String>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
