/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.backend.mail.api.IMailboxFolders.
 */
namespace net.bluemind.backend.mail.api
{

  public class MailboxFoldersClient : BMClient
  {
    private String partition;
    private String mailboxRoot;
  
    /*
     * Constructor 
     */
    public MailboxFoldersClient(String baseUrl, String sid , String partition , String mailboxRoot )
    {
      this.baseUrl = baseUrl + "/api/mail_folders/{partition}/{mailboxRoot}";      
      this.sid = sid;
      this.partition = partition;
      this.baseUrl = this.baseUrl.Replace("{partition}", partition);
      this.mailboxRoot = mailboxRoot;
      this.baseUrl = this.baseUrl.Replace("{mailboxRoot}", mailboxRoot);
      this.logger = new DefaultLogger();
      this.version = "5.5.3184";
    }
    
    public List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> all()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_all";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder> byName(String name )
    {
      String methodVerb = "GET";
      String methodPathValue = "/byName/{name}";
      methodPathValue = methodPathValue.Replace("{name}", HttpUtility.UrlEncode("" + name));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ContainerChangeset<String> changeset(long? since )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_changeset";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("since", since.ToString());

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ContainerChangeset<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ContainerChangeset<long?> changesetById(long? since )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_changesetById";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("since", since.ToString());

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ContainerChangeset<long?>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> childrensOf(String folderUid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/childensof/{folderUid}";
      methodPathValue = methodPathValue.Replace("{folderUid}", HttpUtility.UrlEncode("" + folderUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.backend.mail.api.FolderCounters> counters(List<long?> folderItemIds )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_counters";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<long?>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, folderItemIds);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.backend.mail.api.FolderCounters>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemIdentifier createBasic(net.bluemind.backend.mail.api.MailboxFolder value )
    {
      String methodVerb = "PUT";
      String methodPathValue = "";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.backend.mail.api.MailboxFolder));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, value);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.container.model.ItemIdentifier>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemIdentifier createForHierarchy(long? hierarchyId, net.bluemind.backend.mail.api.MailboxFolder value )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/id/{hierarchyId}";
      methodPathValue = methodPathValue.Replace("{hierarchyId}", HttpUtility.UrlEncode("" + hierarchyId));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.backend.mail.api.MailboxFolder));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, value);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.container.model.ItemIdentifier>(methodPathValue, queryParams, body, methodVerb);
    }
    public void deepDelete(long? id )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/deep/{id}";
      methodPathValue = methodPathValue.Replace("{id}", HttpUtility.UrlEncode("" + id));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void deleteById(long? id )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/id/{id}";
      methodPathValue = methodPathValue.Replace("{id}", HttpUtility.UrlEncode("" + id));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void emptyFolder(long? id )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/empty/{id}";
      methodPathValue = methodPathValue.Replace("{id}", HttpUtility.UrlEncode("" + id));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion> filteredChangesetById(long? since, net.bluemind.core.container.model.ItemFlagFilter arg1 )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_filteredChangesetById";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("since", since.ToString());

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.core.container.model.ItemFlagFilter));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg1);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder> getComplete(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/complete";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder> getCompleteById(long? id )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{id}/completeById";
      methodPathValue = methodPathValue.Replace("{id}", HttpUtility.UrlEncode("" + id));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>(methodPathValue, queryParams, body, methodVerb);
    }
    public String getFullName(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/fullname";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<String>(methodPathValue, queryParams, body, methodVerb);
    }
    public long? getVersion()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_version";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<long?>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.backend.mail.api.ImportMailboxItemsStatus importItems(long? folderDestinationId, net.bluemind.backend.mail.api.ImportMailboxItemSet mailboxItems )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/importItems/{folderDestinationId}";
      methodPathValue = methodPathValue.Replace("{folderDestinationId}", HttpUtility.UrlEncode("" + folderDestinationId));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.backend.mail.api.ImportMailboxItemSet));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, mailboxItems);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.backend.mail.api.ImportMailboxItemsStatus>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemChangelog itemChangelog(String uid, long? arg1 )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/_itemchangelog";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(long?));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg1);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.container.model.ItemChangelog>(methodPathValue, queryParams, body, methodVerb);
    }
    public void markFolderAsRead(long? id )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/markAsRead/{id}";
      methodPathValue = methodPathValue.Replace("{id}", HttpUtility.UrlEncode("" + id));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> multipleGetById(List<long?> arg0 )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_mgetById";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<long?>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg0);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void removeMessages(long? id )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/removeMessages/{id}";
      methodPathValue = methodPathValue.Replace("{id}", HttpUtility.UrlEncode("" + id));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder> root()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_root";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.backend.mail.api.SearchResult searchItems(net.bluemind.backend.mail.api.MailboxFolderSearchQuery query )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_search";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.backend.mail.api.MailboxFolderSearchQuery));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, query);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.backend.mail.api.SearchResult>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder> trash()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_trash";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.api.Ack updateById(long? id, net.bluemind.backend.mail.api.MailboxFolder value )
    {
      String methodVerb = "POST";
      String methodPathValue = "/id/{id}";
      methodPathValue = methodPathValue.Replace("{id}", HttpUtility.UrlEncode("" + id));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.backend.mail.api.MailboxFolder));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, value);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.container.api.Ack>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
