/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.backend.mail.api.IItemsTransfer.
 */
namespace net.bluemind.backend.mail.api
{

  public class ItemsTransferClient : BMClient
  {
    private String fromMailboxUid;
    private String toMailboxUid;
  
    /*
     * Constructor 
     */
    public ItemsTransferClient(String baseUrl, String sid , String fromMailboxUid , String toMailboxUid )
    {
      this.baseUrl = baseUrl + "/api/mail_items_transfer/{fromMailboxUid}/{toMailboxUid}";      
      this.sid = sid;
      this.fromMailboxUid = fromMailboxUid;
      this.baseUrl = this.baseUrl.Replace("{fromMailboxUid}", fromMailboxUid);
      this.toMailboxUid = toMailboxUid;
      this.baseUrl = this.baseUrl.Replace("{toMailboxUid}", toMailboxUid);
      this.logger = new DefaultLogger();
      this.version = "5.5.3184";
    }
    
    public List<net.bluemind.core.container.model.ItemIdentifier> copy(List<long?> itemIds )
    {
      String methodVerb = "POST";
      String methodPathValue = "/copy";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<long?>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, itemIds);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.core.container.model.ItemIdentifier>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ItemIdentifier> move(List<long?> itemIds )
    {
      String methodVerb = "POST";
      String methodPathValue = "/move";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<long?>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, itemIds);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.core.container.model.ItemIdentifier>>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
