/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.authentication.api.IInternalAuthentication.
 */
namespace net.bluemind.authentication.api
{

  public class InternalAuthenticationClient : BMClient
  {
  
    /*
     * Constructor 
     */
    public InternalAuthenticationClient(String baseUrl, String sid )
    {
      this.baseUrl = baseUrl + "/api/auth";      
      this.sid = sid;
      this.logger = new DefaultLogger();
      this.version = "5.5.3184";
    }
    
    public void backchannelLogout(Stream contentStream )
    {
      String methodVerb = "POST";
      String methodPathValue = "/logout/backchannel";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      body = contentStream;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.authentication.api.AuthUser getCurrentUser()
    {
      String methodVerb = "GET";
      String methodPathValue = "";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.authentication.api.AuthUser>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.authentication.api.LoginResponse login(String login, String password, String origin )
    {
      String methodVerb = "POST";
      String methodPathValue = "/login";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("login", login.ToString());
      queryParams.Add("origin", origin.ToString());

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(String));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, password);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.authentication.api.LoginResponse>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.authentication.api.LoginResponse loginWithParams(String login, String password, String origin, Boolean? interactive )
    {
      String methodVerb = "POST";
      String methodPathValue = "/loginWithParams";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("login", login.ToString());
      queryParams.Add("origin", origin.ToString());
      queryParams.Add("interactive", interactive.ToString());

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(String));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, password);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.authentication.api.LoginResponse>(methodPathValue, queryParams, body, methodVerb);
    }
    public void logout()
    {
      String methodVerb = "POST";
      String methodPathValue = "/logout";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void ping()
    {
      String methodVerb = "GET";
      String methodPathValue = "/ping";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.authentication.api.LoginResponse su(String login )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_su";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("login", login.ToString());

      dynamic body = null;
      return this.execute<net.bluemind.authentication.api.LoginResponse>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.authentication.api.LoginResponse suWithParams(String login, Boolean? interactive )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_suWithParams";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("login", login.ToString());
      queryParams.Add("interactive", interactive.ToString());

      dynamic body = null;
      return this.execute<net.bluemind.authentication.api.LoginResponse>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.authentication.api.ValidationKind validate(String login, String password, String origin )
    {
      String methodVerb = "POST";
      String methodPathValue = "/validate";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("login", login.ToString());
      queryParams.Add("origin", origin.ToString());

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(String));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, password);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.authentication.api.ValidationKind>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.authentication.api.ValidationKind validateCredentials(String login, String origin, String password )
    {
      String methodVerb = "POST";
      String methodPathValue = "/validatecredential";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("login", login.ToString());
      queryParams.Add("origin", origin.ToString());

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(String));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, password);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.authentication.api.ValidationKind>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
