/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.attachment.api.IAttachment.
 */
namespace net.bluemind.attachment.api
{

  public class AttachmentClient : BMClient
  {
    private String domainUid;
  
    /*
     * Constructor 
     */
    public AttachmentClient(String baseUrl, String sid , String domainUid )
    {
      this.baseUrl = baseUrl + "/api/attachment/{domainUid}";      
      this.sid = sid;
      this.domainUid = domainUid;
      this.baseUrl = this.baseUrl.Replace("{domainUid}", domainUid);
      this.logger = new DefaultLogger();
      this.version = "5.5.3184";
    }
    
    public net.bluemind.attachment.api.Configuration getConfiguration()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_config";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.attachment.api.Configuration>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.attachment.api.AttachedFile share(String name, Stream document )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/{name}/share";
      methodPathValue = methodPathValue.Replace("{name}", HttpUtility.UrlEncode("" + name));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      body = document;
      return this.execute<net.bluemind.attachment.api.AttachedFile>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.attachment.api.AttachedFile shareDedup(String extension, Stream document )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/{extension}/share_dedup";
      methodPathValue = methodPathValue.Replace("{extension}", HttpUtility.UrlEncode("" + extension));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      body = document;
      return this.execute<net.bluemind.attachment.api.AttachedFile>(methodPathValue, queryParams, body, methodVerb);
    }
    public void unShare(String url )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/{url}/unshare";
      methodPathValue = methodPathValue.Replace("{url}", HttpUtility.UrlEncode("" + url));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
