/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.addressbook.api.IAddressBooks.
 */
namespace net.bluemind.addressbook.api
{

  public class AddressBooksClient : BMClient
  {
  
    /*
     * Constructor 
     */
    public AddressBooksClient(String baseUrl, String sid )
    {
      this.baseUrl = baseUrl + "/api/addressbooks";      
      this.sid = sid;
      this.logger = new DefaultLogger();
      this.version = "5.5.3184";
    }
    
    public List<net.bluemind.addressbook.api.CertInfo> findCertsByEmail(String email )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_findCertsByEmail";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("email", email.ToString());

      dynamic body = null;
      return this.execute<List<net.bluemind.addressbook.api.CertInfo>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<String> findUidsByEmail(String email )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_findUidsByEmail";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(String));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, email);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.addressbook.api.VCardInfo>> search(net.bluemind.addressbook.api.VCardQuery query )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_search";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.addressbook.api.VCardQuery));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, query);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.addressbook.api.VCardInfo>>>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
