import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './WebAppDataUidsClient.json';

export class WebAppDataUidsClient extends ApiEndPoint {
    version = "5.5.3184";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/webappdata/uids');
    }
    async getContainerUid(userUid,  __fetchOptions = {}) {
        let __path = this.base + '/{userUid}/_container_uid';
        __path = __path.replace('{userUid}', encodeURIComponent(userUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
