import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './TagsClient.json';

export class TagsClient extends ApiEndPoint {
    version = "5.5.3184";
    constructor(apiKey, containerUid , base = '') {
        super(apiKey, base + '/api/tags/{containerUid}');
        this.containerUid = containerUid;
        this.base = this.base.replace('{containerUid}', encodeURIComponent(containerUid));
    }
    async all( __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async allUids( __fetchOptions = {}) {
        let __path = this.base + '/_alluids';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async changeset(since,  __fetchOptions = {}) {
        let __path = this.base + '/_changeset';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (since != null) {
            __url.searchParams.append("since", since);
        }
		return this.__fetchContent(__url, __options);
    }
    async create(uid, tag,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (tag != null) {
            __options.body = JSON.stringify(tag);
        }
		return this.__fetchVoid(__url, __options);
    }
    async delete(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async getComplete(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async multipleGet(uids,  __fetchOptions = {}) {
        let __path = this.base + '/_mget';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (uids != null) {
            __options.body = JSON.stringify(uids);
        }
		return this.__fetchContent(__url, __options);
    }
    async update(uid, tag,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (tag != null) {
            __options.body = JSON.stringify(tag);
        }
		return this.__fetchVoid(__url, __options);
    }
    async updates(changes,  __fetchOptions = {}) {
        let __path = this.base + '/_mupdates';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (changes != null) {
            __options.body = JSON.stringify(changes);
        }
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
