import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './NoteIndexMgmtClient.json';

export class NoteIndexMgmtClient extends ApiEndPoint {
    version = "5.5.3184";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/mgmt/notes');
    }
    async reindex(containerUid,  __fetchOptions = {}) {
        let __path = this.base + '/{containerUid}/_reindex';
        __path = __path.replace('{containerUid}', encodeURIComponent(containerUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async reindexAll( __fetchOptions = {}) {
        let __path = this.base + '/_reindex';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
