import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './MailboxesClient.json';

export class MailboxesClient extends ApiEndPoint {
    version = "5.5.3184";
    constructor(apiKey, domainUid , base = '') {
        super(apiKey, base + '/api/mailboxes/{domainUid}');
        this.domainUid = domainUid;
        this.base = this.base.replace('{domainUid}', encodeURIComponent(domainUid));
    }
    async addDomainRule(rule,  __fetchOptions = {}) {
        let __path = this.base + '/_rules';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (rule != null) {
            __options.body = JSON.stringify(rule);
        }
		return this.__fetchContent(__url, __options);
    }
    async addMailboxRule(mailboxUid, rule,  __fetchOptions = {}) {
        let __path = this.base + '/{mailboxUid}/_rules';
        __path = __path.replace('{mailboxUid}', encodeURIComponent(mailboxUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (rule != null) {
            __options.body = JSON.stringify(rule);
        }
		return this.__fetchContent(__url, __options);
    }
    async addMailboxRuleRelative(mailboxUid, position, anchorId, rule,  __fetchOptions = {}) {
        let __path = this.base + '/{mailboxUid}/_rules/{position}/{anchorId}';
        __path = __path.replace('{mailboxUid}', encodeURIComponent(mailboxUid));
        __path = __path.replace('{position}', encodeURIComponent(position));
        __path = __path.replace('{anchorId}', encodeURIComponent(anchorId));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (rule != null) {
            __options.body = JSON.stringify(rule);
        }
		return this.__fetchContent(__url, __options);
    }
    async byEmail(email,  __fetchOptions = {}) {
        let __path = this.base + '/_byemail';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (email != null) {
            __url.searchParams.append("email", email);
        }
		return this.__fetchContent(__url, __options);
    }
    async byName(name,  __fetchOptions = {}) {
        let __path = this.base + '/_byname';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (name != null) {
            __url.searchParams.append("name", name);
        }
		return this.__fetchContent(__url, __options);
    }
    async byRouting(email,  __fetchOptions = {}) {
        let __path = this.base + '/_byRouting';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (email != null) {
            __url.searchParams.append("email", email);
        }
		return this.__fetchContent(__url, __options);
    }
    async create(uid, mailbox,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (mailbox != null) {
            __options.body = JSON.stringify(mailbox);
        }
		return this.__fetchVoid(__url, __options);
    }
    async delete(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async deleteDomainRule(id,  __fetchOptions = {}) {
        let __path = this.base + '/_rules/{id}';
        __path = __path.replace('{id}', encodeURIComponent(id));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async deleteMailboxRule(mailboxUid, id,  __fetchOptions = {}) {
        let __path = this.base + '/{mailboxUid}/_rules/{id}';
        __path = __path.replace('{mailboxUid}', encodeURIComponent(mailboxUid));
        __path = __path.replace('{id}', encodeURIComponent(id));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async getComplete(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/complete';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getDomainFilter( __fetchOptions = {}) {
        let __path = this.base + '/_filter';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getDomainRule(id,  __fetchOptions = {}) {
        let __path = this.base + '/_rules/{id}';
        __path = __path.replace('{id}', encodeURIComponent(id));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getDomainRules( __fetchOptions = {}) {
        let __path = this.base + '/_rules';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getMailboxAccessControlList(mailboxUid,  __fetchOptions = {}) {
        let __path = this.base + '/{mailboxUid}/_acls';
        __path = __path.replace('{mailboxUid}', encodeURIComponent(mailboxUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getMailboxConfig(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_config';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getMailboxDelegationRule(mailboxUid,  __fetchOptions = {}) {
        let __path = this.base + '/{mailboxUid}/_delegationRule';
        __path = __path.replace('{mailboxUid}', encodeURIComponent(mailboxUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getMailboxFilter(mailboxUid,  __fetchOptions = {}) {
        let __path = this.base + '/{mailboxUid}/_filter';
        __path = __path.replace('{mailboxUid}', encodeURIComponent(mailboxUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getMailboxForwarding(mailboxUid,  __fetchOptions = {}) {
        let __path = this.base + '/{mailboxUid}/_forwarding';
        __path = __path.replace('{mailboxUid}', encodeURIComponent(mailboxUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getMailboxQuota(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_quota';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getMailboxRule(mailboxUid, id,  __fetchOptions = {}) {
        let __path = this.base + '/{mailboxUid}/_rules/{id}';
        __path = __path.replace('{mailboxUid}', encodeURIComponent(mailboxUid));
        __path = __path.replace('{id}', encodeURIComponent(id));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getMailboxRules(mailboxUid,  __fetchOptions = {}) {
        let __path = this.base + '/{mailboxUid}/_rules';
        __path = __path.replace('{mailboxUid}', encodeURIComponent(mailboxUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getMailboxRulesByClient(mailboxUid, client,  __fetchOptions = {}) {
        let __path = this.base + '/{mailboxUid}/_rulesByClient';
        __path = __path.replace('{mailboxUid}', encodeURIComponent(mailboxUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (client != null) {
            __url.searchParams.append("client", client);
        }
		return this.__fetchContent(__url, __options);
    }
    async getMailboxVacation(mailboxUid,  __fetchOptions = {}) {
        let __path = this.base + '/{mailboxUid}/_vacation';
        __path = __path.replace('{mailboxUid}', encodeURIComponent(mailboxUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getUnreadMessagesCount( __fetchOptions = {}) {
        let __path = this.base + '/_unread';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async list( __fetchOptions = {}) {
        let __path = this.base + '/_list';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async listUids( __fetchOptions = {}) {
        let __path = this.base + '/_listUids';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async moveMailboxRule(mailboxUid, id, direction,  __fetchOptions = {}) {
        let __path = this.base + '/{mailboxUid}/_rules/{id}/{direction}';
        __path = __path.replace('{mailboxUid}', encodeURIComponent(mailboxUid));
        __path = __path.replace('{id}', encodeURIComponent(id));
        __path = __path.replace('{direction}', encodeURIComponent(direction));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async moveMailboxRuleRelative(mailboxUid, id, position, anchorId,  __fetchOptions = {}) {
        let __path = this.base + '/{mailboxUid}/_rules/{id}/{position}/{anchorId}';
        __path = __path.replace('{mailboxUid}', encodeURIComponent(mailboxUid));
        __path = __path.replace('{id}', encodeURIComponent(id));
        __path = __path.replace('{position}', encodeURIComponent(position));
        __path = __path.replace('{anchorId}', encodeURIComponent(anchorId));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async multipleGet(uids,  __fetchOptions = {}) {
        let __path = this.base + '/_mget';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (uids != null) {
            __options.body = JSON.stringify(uids);
        }
		return this.__fetchContent(__url, __options);
    }
    async setDomainFilter(filter,  __fetchOptions = {}) {
        let __path = this.base + '/_filter';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (filter != null) {
            __options.body = JSON.stringify(filter);
        }
		return this.__fetchVoid(__url, __options);
    }
    async setMailboxAccessControlList(mailboxUid, accessControlEntries,  __fetchOptions = {}) {
        let __path = this.base + '/{mailboxUid}/_acls';
        __path = __path.replace('{mailboxUid}', encodeURIComponent(mailboxUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (accessControlEntries != null) {
            __options.body = JSON.stringify(accessControlEntries);
        }
		return this.__fetchVoid(__url, __options);
    }
    async setMailboxDelegationRule(mailboxUid, delegationRule,  __fetchOptions = {}) {
        let __path = this.base + '/{mailboxUid}/_delegationRule';
        __path = __path.replace('{mailboxUid}', encodeURIComponent(mailboxUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (delegationRule != null) {
            __options.body = JSON.stringify(delegationRule);
        }
		return this.__fetchVoid(__url, __options);
    }
    async setMailboxFilter(mailboxUid, filter,  __fetchOptions = {}) {
        let __path = this.base + '/{mailboxUid}/_filter';
        __path = __path.replace('{mailboxUid}', encodeURIComponent(mailboxUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (filter != null) {
            __options.body = JSON.stringify(filter);
        }
		return this.__fetchVoid(__url, __options);
    }
    async setMailboxForwarding(mailboxUid, forwarding,  __fetchOptions = {}) {
        let __path = this.base + '/{mailboxUid}/_forwarding';
        __path = __path.replace('{mailboxUid}', encodeURIComponent(mailboxUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (forwarding != null) {
            __options.body = JSON.stringify(forwarding);
        }
		return this.__fetchVoid(__url, __options);
    }
    async setMailboxVacation(mailboxUid, vacation,  __fetchOptions = {}) {
        let __path = this.base + '/{mailboxUid}/_vacation';
        __path = __path.replace('{mailboxUid}', encodeURIComponent(mailboxUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (vacation != null) {
            __options.body = JSON.stringify(vacation);
        }
		return this.__fetchVoid(__url, __options);
    }
    async update(uid, mailbox,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (mailbox != null) {
            __options.body = JSON.stringify(mailbox);
        }
		return this.__fetchVoid(__url, __options);
    }
    async updateDomainRule(id, rule,  __fetchOptions = {}) {
        let __path = this.base + '/_rules/{id}';
        __path = __path.replace('{id}', encodeURIComponent(id));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (rule != null) {
            __options.body = JSON.stringify(rule);
        }
		return this.__fetchVoid(__url, __options);
    }
    async updateMailboxRule(mailboxUid, id, rule,  __fetchOptions = {}) {
        let __path = this.base + '/{mailboxUid}/_rules/{id}';
        __path = __path.replace('{mailboxUid}', encodeURIComponent(mailboxUid));
        __path = __path.replace('{id}', encodeURIComponent(id));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (rule != null) {
            __options.body = JSON.stringify(rule);
        }
		return this.__fetchVoid(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
