
import { FileHostingPublicLink } from "./FileHostingPublicLink"; 
import { Configuration } from "./Configuration"; 
import { FileHostingInfo } from "./FileHostingInfo"; 
import { FileHostingItem } from "./FileHostingItem"; 
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface IFileHosting {
    /**
     * Deletes a document
     * @param path the relative path in the file hosting repository
     */
    delete(path: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Checks if a file exists
     * @param path the relative path to the document
     * @returns true if the file exists, false otherwise
     */
    exists(path: string,  __fetchOptions?: RequestOptions): Promise<boolean>;
    /**
     * Finds items in the file hosting repository
     * @param query the query. The format of the query is repository dependent
     * @returns all items matching the query
     */
    find(query?: string,  __fetchOptions?: RequestOptions): Promise<Array<FileHostingItem>>;
    /**
     * Retrieves a document from the file hosting repository
     * @param path the relative path to the document
     * @returns the document data
     */
    get(path: string,  __fetchOptions?: RequestOptions): Promise<Blob>;
    /**
     * Retrieves the configuration
     * @returns the Filehosting service configuration
     */
    getConfiguration( __fetchOptions?: RequestOptions): Promise<Configuration>;
    /**
     * Retrieves informations about the filehosting implementation
     */
    info( __fetchOptions?: RequestOptions): Promise<FileHostingInfo>;
    /**
     * Lists files and folders. The listing contains only non-recursive items
     * @param path the folder path
     * @returns the files and folders found under this path
     */
    list(path?: string,  __fetchOptions?: RequestOptions): Promise<Array<FileHostingItem>>;
    /**
     * Retrieves a public URL to the document in the file hosting repository
     * @param path the relative path to the document
     * @param downloadLimit the number of times the file can be downloaded, <= 0 if
     *                       unlimited
     * @param expirationDate a ISO-8601 compliant date, null otherwise
     * @returns the URL pointing to this document
     */
    share(path?: string, downloadLimit?: number, expirationDate?: string,  __fetchOptions?: RequestOptions): Promise<FileHostingPublicLink>;
    /**
     * Update/insert a document
     * @param path the relative path in the file hosting repository
     * @param document the document data
     */
    store(path: string, document?: ReadableStream<any> | string | Blob,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Store a document and retrieves a public URL to the document in the file
     * hosting repository
     * @param path the relative path to the document
     * @param downloadLimit the number of times the file can be downloaded, <= 0 if
     *                       unlimited
     * @param expirationDate a ISO-8601 compliant date, null otherwise
     * @param document the document
     * @returns the URL pointing to this document
     */
    storeAndShare(path?: string, downloadLimit?: number, expirationDate?: string, document?: ReadableStream<any> | string | Blob,  __fetchOptions?: RequestOptions): Promise<FileHostingPublicLink>;
    /**
     * Remove a public link
     * @param url the share url
     */
    unShare(url: string,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class FileHostingClient extends ApiEndPoint implements IFileHosting {
    domainUid: string;
    constructor(apiKey: string, domainUid: string, base?: string);
    delete(path: string,  __fetchOptions?: RequestOptions): Promise<void>;
    exists(path: string,  __fetchOptions?: RequestOptions): Promise<boolean>;
    find(query?: string,  __fetchOptions?: RequestOptions): Promise<Array<FileHostingItem>>;
    get(path: string,  __fetchOptions?: RequestOptions): Promise<Blob>;
    getConfiguration( __fetchOptions?: RequestOptions): Promise<Configuration>;
    info( __fetchOptions?: RequestOptions): Promise<FileHostingInfo>;
    list(path?: string,  __fetchOptions?: RequestOptions): Promise<Array<FileHostingItem>>;
    share(path?: string, downloadLimit?: number, expirationDate?: string,  __fetchOptions?: RequestOptions): Promise<FileHostingPublicLink>;
    store(path: string, document?: ReadableStream<any> | string | Blob,  __fetchOptions?: RequestOptions): Promise<void>;
    storeAndShare(path?: string, downloadLimit?: number, expirationDate?: string, document?: ReadableStream<any> | string | Blob,  __fetchOptions?: RequestOptions): Promise<FileHostingPublicLink>;
    unShare(url: string,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
