import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './DocumentFolderUidsClient.json';

export class DocumentFolderUidsClient extends ApiEndPoint {
    version = "5.5.3184";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/document/uids');
    }
    async documentFolderContainerUid(domain,  __fetchOptions = {}) {
        let __path = this.base + '/{domain}/_documentfolder';
        __path = __path.replace('{domain}', encodeURIComponent(domain));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
