import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './DirectoryClient.json';

export class DirectoryClient extends ApiEndPoint {
    version = "5.5.3184";
    constructor(apiKey, domain , base = '') {
        super(apiKey, base + '/api/directory/{domain}');
        this.domain = domain;
        this.base = this.base.replace('{domain}', encodeURIComponent(domain));
    }
    async changeset(since,  __fetchOptions = {}) {
        let __path = this.base + '/_changeset';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (since != null) {
            __url.searchParams.append("since", since);
        }
		return this.__fetchContent(__url, __options);
    }
    async delete(path,  __fetchOptions = {}) {
        let __path = this.base + '/{path}';
        __path = __path.replace('{path}', encodeURIComponent(path));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async deleteByEntryUid(entryUid,  __fetchOptions = {}) {
        let __path = this.base + '/_byentryuid/{entryUid}';
        __path = __path.replace('{entryUid}', encodeURIComponent(entryUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async findByEntryUid(entryUid,  __fetchOptions = {}) {
        let __path = this.base + '/entry-uid/{entryUid}';
        __path = __path.replace('{entryUid}', encodeURIComponent(entryUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async findItemValueByEntryUid(entryUid,  __fetchOptions = {}) {
        let __path = this.base + '/item-value-uid/{entryUid}';
        __path = __path.replace('{entryUid}', encodeURIComponent(entryUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getByEmail(email,  __fetchOptions = {}) {
        let __path = this.base + '/_byEmail/{email}';
        __path = __path.replace('{email}', encodeURIComponent(email));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getByRoles(roles,  __fetchOptions = {}) {
        let __path = this.base + '/_byroles';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (roles != null) {
            __options.body = JSON.stringify(roles);
        }
		return this.__fetchContent(__url, __options);
    }
    async getEntries(path,  __fetchOptions = {}) {
        let __path = this.base + '/_childs';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (path != null) {
            __options.body = JSON.stringify(path);
        }
		return this.__fetchContent(__url, __options);
    }
    async getEntry(path,  __fetchOptions = {}) {
        let __path = this.base + '/_entry';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (path != null) {
            __options.body = JSON.stringify(path);
        }
		return this.__fetchContent(__url, __options);
    }
    async getEntryIcon(entryUid,  __fetchOptions = {}) {
        let __path = this.base + '/entry-uid/{entryUid}/icon';
        __path = __path.replace('{entryUid}', encodeURIComponent(entryUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getEntryPhoto(entryUid,  __fetchOptions = {}) {
        let __path = this.base + '/entry-uid/{entryUid}/photo';
        __path = __path.replace('{entryUid}', encodeURIComponent(entryUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getIcon(path,  __fetchOptions = {}) {
        let __path = this.base + '/_icon/{path}';
        __path = __path.replace('{path}', encodeURIComponent(path));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getMultiple(id,  __fetchOptions = {}) {
        let __path = this.base + '/_mget';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (id != null) {
            __options.body = JSON.stringify(id);
        }
		return this.__fetchContent(__url, __options);
    }
    async getMultipleLight(id,  __fetchOptions = {}) {
        let __path = this.base + '/_mgetlight';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (id != null) {
            __options.body = JSON.stringify(id);
        }
		return this.__fetchContent(__url, __options);
    }
    async getRolesForDirEntry(entryUid,  __fetchOptions = {}) {
        let __path = this.base + '/entry-uid/{entryUid}/rolesfor_';
        __path = __path.replace('{entryUid}', encodeURIComponent(entryUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getRolesForOrgUnit(ouUid,  __fetchOptions = {}) {
        let __path = this.base + '/ou-uid/{ouUid}/rolesfor_';
        __path = __path.replace('{ouUid}', encodeURIComponent(ouUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getRoot( __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getVCard(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_vcard';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async search(query,  __fetchOptions = {}) {
        let __path = this.base + '/_search';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (query != null) {
            __options.body = JSON.stringify(query);
        }
		return this.__fetchContent(__url, __options);
    }
    async searchUids(query,  __fetchOptions = {}) {
        let __path = this.base + '/_searchUids';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (query != null) {
            __options.body = JSON.stringify(query);
        }
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
