import { 
    Email
} from "@bluemind/core.foldershare.api";

import { BaseDirEntry } from "./BaseDirEntry"; 
import { OrgUnitPath } from "./OrgUnitPath"; 
/**
 * Data structure of directory related entities
 */
export type DirEntry = BaseDirEntry & {
    /**
     * Path of the {@link DirEntry} in the format<br>
     * <b>domainUid/kind/entryUid</b>
     */
    path?: string;
    /**
     * Email address
     */
    email?: string;
    /**
     * True, if this {@link DirEntry} is hidden from all user views
     */
    hidden?: boolean;
    /**
     * True, if this is a system-internal account
     */
    system?: boolean;
    /**
     * True, if this is a system-internal account
     */
    archived?: boolean;
    /**
     * List of emails associated to this {@link DirEntry}
     */
    emails?: Array<Email>;
    /**
     * Optional unique if of the organizational unit this {@link DirEntry} belongs
     * to
     */
    orgUnitUid?: string;
    /**
     * Optional unique if of the organizational unit this {@link DirEntry} belongs
     * to
     */
    orgUnitPath?: OrgUnitPath;
    /**
     * The unique id of the {@link net.bluemind.server.api.Server} this
     * {@link DirEntry} belongs to
     */
    dataLocation?: string;
    /**
     * NSPI Identifier for MAPI
     */
    minId?: number;
};
