import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * To unify the management of changelogs, ACLs, client synchronization,
 * permissions and sharing, Bluemind stores all elements in a generic structure
 * called a container. All containers are identified by a unique ID. Some
 * containers are named (UID) in a specific manner to express a certain meaning.
 * 
 * 
 * Returns the flat container hierarchy container UID.
 */
export interface IFlatHierarchyUids {
    /**
     * Returns the flat container hierarchy container UID
     * @param domain id
     *                      the domain
     * @returns flat container hierarchy container UID
     */
    identifier(uid: string, domain: string,  __fetchOptions?: RequestOptions): Promise<string>;
}

export declare class FlatHierarchyUidsClient extends ApiEndPoint implements IFlatHierarchyUids {
    constructor(apiKey: string, base?: string);
    identifier(uid: string, domain: string,  __fetchOptions?: RequestOptions): Promise<string>;
    getMetadata(): EndPointMetadata;
}
