
import { ContainerModifiableDescriptor } from "./ContainerModifiableDescriptor"; 
import { ContainerQuery } from "./ContainerQuery"; 
import { AccessControlEntry } from "./AccessControlEntry"; 
import { ContainerDescriptor } from "./ContainerDescriptor"; 
import { BaseContainerDescriptor } from "./BaseContainerDescriptor"; 
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface IContainers {
    /**
     * @returns List of all "readeable" containers for current User
     */
    all(query?: ContainerQuery,  __fetchOptions?: RequestOptions): Promise<Array<ContainerDescriptor>>;
    /**
     * @returns List of all "readeable" containers for current User
     */
    allForUser(domainUid?: string, userUid?: string, query?: ContainerQuery,  __fetchOptions?: RequestOptions): Promise<Array<ContainerDescriptor>>;
    allLight(query?: ContainerQuery,  __fetchOptions?: RequestOptions): Promise<Array<BaseContainerDescriptor>>;
    /**
     * Create a container
     */
    create(uid: string, descriptor?: ContainerDescriptor,  __fetchOptions?: RequestOptions): Promise<BaseContainerDescriptor>;
    /**
     * Delete a container
     */
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    exists(containerUid?: string,  __fetchOptions?: RequestOptions): Promise<boolean>;
    /**
     * Get a container
     * @param uid the containers unique identifier
     * @returns non null description, throws if not found
     */
    get(uid: string,  __fetchOptions?: RequestOptions): Promise<ContainerDescriptor>;
    getAccessControlLists(containerIds?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Record<string, Array<AccessControlEntry>>>;
    /**
     * Get container
     * @returns {@link ContainerDescriptor} list
     */
    getContainers(containerIds?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ContainerDescriptor>>;
    /**
     * Get container
     * @returns {@link BaseContainerDescriptor} list
     */
    getContainersLight(containerIds?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<BaseContainerDescriptor>>;
    /**
     * Get a container as if it where requested by another user.
     */
    getForUser(domainUid?: string, userUid?: string, uid?: string,  __fetchOptions?: RequestOptions): Promise<ContainerDescriptor>;
    /**
     * Get a container
     */
    getIfPresent(uid: string,  __fetchOptions?: RequestOptions): Promise<ContainerDescriptor>;
    getLight(uid: string,  __fetchOptions?: RequestOptions): Promise<BaseContainerDescriptor>;
    getLightIfPresent(uid: string,  __fetchOptions?: RequestOptions): Promise<BaseContainerDescriptor>;
    setAccessControlList(uid: string, entries?: Array<AccessControlEntry>,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Update a container
     */
    update(uid: string, descriptor?: ContainerModifiableDescriptor,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class ContainersClient extends ApiEndPoint implements IContainers {
    constructor(apiKey: string, base?: string);
    all(query?: ContainerQuery,  __fetchOptions?: RequestOptions): Promise<Array<ContainerDescriptor>>;
    allForUser(domainUid?: string, userUid?: string, query?: ContainerQuery,  __fetchOptions?: RequestOptions): Promise<Array<ContainerDescriptor>>;
    allLight(query?: ContainerQuery,  __fetchOptions?: RequestOptions): Promise<Array<BaseContainerDescriptor>>;
    create(uid: string, descriptor?: ContainerDescriptor,  __fetchOptions?: RequestOptions): Promise<BaseContainerDescriptor>;
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    exists(containerUid?: string,  __fetchOptions?: RequestOptions): Promise<boolean>;
    get(uid: string,  __fetchOptions?: RequestOptions): Promise<ContainerDescriptor>;
    getAccessControlLists(containerIds?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Record<string, Array<AccessControlEntry>>>;
    getContainers(containerIds?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ContainerDescriptor>>;
    getContainersLight(containerIds?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<BaseContainerDescriptor>>;
    getForUser(domainUid?: string, userUid?: string, uid?: string,  __fetchOptions?: RequestOptions): Promise<ContainerDescriptor>;
    getIfPresent(uid: string,  __fetchOptions?: RequestOptions): Promise<ContainerDescriptor>;
    getLight(uid: string,  __fetchOptions?: RequestOptions): Promise<BaseContainerDescriptor>;
    getLightIfPresent(uid: string,  __fetchOptions?: RequestOptions): Promise<BaseContainerDescriptor>;
    setAccessControlList(uid: string, entries?: Array<AccessControlEntry>,  __fetchOptions?: RequestOptions): Promise<void>;
    update(uid: string, descriptor?: ContainerModifiableDescriptor,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
