
/**
 * Changelog entry
 */
export type ChangeLogEntry = {
    /**
     * change version
     */
    version?: number;
    /**
     * changed item uid
     */
    itemUid?: string;
    /**
     * changed item external id
     */
    itemExtId?: string;
    /**
     * changes author
     */
    author?: string;
    /**
     * changes type (created/updated/deleted)
     */
    type?: ChangeLogEntry.Type;
    /**
     * changes date
     */
    date?: number;
    /**
     * origin of the change, as given in the security context
     */
    origin?: string;
    internalId?: number;
    weightSeed?: number;
};
export namespace ChangeLogEntry {
    export type Type =  "Created" |  "Updated" |  "Deleted";
    export const Type : {
        readonly Created: Type,
        readonly Updated: Type,
        readonly Deleted: Type
    };

}
