import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './CalendarsMgmtClient.json';

export class CalendarsMgmtClient extends ApiEndPoint {
    version = "5.5.3184";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/mgmt/calendars');
    }
    async create(uid, descriptor,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (descriptor != null) {
            __options.body = JSON.stringify(descriptor);
        }
		return this.__fetchVoid(__url, __options);
    }
    async delete(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async getComplete(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async reindex(containerUid,  __fetchOptions = {}) {
        let __path = this.base + '/{containerUid}/_reindex';
        __path = __path.replace('{containerUid}', encodeURIComponent(containerUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async reindexAll( __fetchOptions = {}) {
        let __path = this.base + '/_reindex';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async update(uid, descriptor,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (descriptor != null) {
            __options.body = JSON.stringify(descriptor);
        }
		return this.__fetchVoid(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
