
/**
 * Defines message search parameters
 */
export type SearchQuery = {
    /**
     * An optional id associated to this query
     */
    searchSessionId?: string;
    /**
     * An Elasticsearch compliant query string
     *
     * body document only
     */
    query?: string;
    /**
     * An Elasticsearch compliant query string
     *
     * record document only
     */
    recordQuery?: string;
    /**
     * Enables the search by the MessageId header
     */
    messageId?: string;
    /**
     * Enables the search by the References header
     */
    references?: string;
    /**
     * Enables the search by the specific header values
     */
    headerQuery?: SearchQuery.HeaderQuery;
    /**
     * Maximum results
     */
    maxResults?: number;
    /**
     * Result Set offset
     */
    offset?: number;
    /**
     * The scope of this search
     */
    scope?: SearchQuery.SearchScope;
    /**
     * Defines the default search operator of {@link #query} and
     * {@link #recordQuery}
     */
    logicalOperator?: SearchQuery.LogicalOperator;
    trackScores?: boolean;
};
export namespace SearchQuery {
    /**
     * Defines the search operator of the requested header search values
     */
    export type LogicalOperator =  "AND" |  "OR";
    export const LogicalOperator : {
        /**
         * Search matches if ALL requested headers are present having the requested
         * value
         */
        readonly AND: LogicalOperator,
        /**
         * Search matches if one of requested headers is present having the requested
         * value
         */
        readonly OR: LogicalOperator
    };
    /**
     * The scope of a search
     */
    export type SearchScope = {
        /**
         * Restricts the search to a specific {@link MailboxFolder}
         */
        folderScope?: SearchQuery.FolderScope;
        /**
         * True if the search is recursive
         */
        isDeepTraversal?: boolean;
    };
    /**
     * Header key/value pair
     */
    export type Header = {
        /**
         * Header name
         */
        name?: string;
        /**
         * Header value
         */
        value?: string;
    };
    /**
     * Definition of a {@link MailboxFolder} search restriction
     */
    export type FolderScope = {
        /**
         * UID of the {@link MailboxFolder}
         */
        folderUid?: string;
    };
    /**
     * Header search
     */
    export type HeaderQuery = {
        /**
         * Defines the search operator of the requested header search values
         */
        logicalOperator?: SearchQuery.LogicalOperator;
        /**
         * List of requested {@link Header}}
         */
        query?: Array<SearchQuery.Header>;
    };

}
