import { 
    ItemIdentifier,
    ContainerChangeset,
    ItemFlagFilter,
    ItemValue,
    Ack,
    ItemChangelog,
    ItemVersion
} from "@bluemind/core.container.api";

import { SearchResult } from "./SearchResult"; 
import { MailboxFolder } from "./MailboxFolder"; 
import { ImportMailboxItemSet } from "./ImportMailboxItemSet"; 
import { ImportMailboxItemsStatus } from "./ImportMailboxItemsStatus"; 
import { MailboxFolderSearchQuery } from "./MailboxFolderSearchQuery"; 
import { FolderCounters } from "./FolderCounters"; 
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * API to access the hierarchy of a user or shared mailbox by its uid.
 *
 * This API is tied to a container of {@link MailboxFolder} with a changelog.
 */
export interface IMailboxFoldersByOwner {
    all( __fetchOptions?: RequestOptions): Promise<Array<ItemValue<MailboxFolder>>>;
    byName(name: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<MailboxFolder>>;
    changeset(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<string>>;
    changesetById(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<number>>;
    childrensOf(folderUid: string,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<MailboxFolder>>>;
    /**
     * Return counters (unseen_visible, total_visible, total) for the given
     * MailboxFolder folder itemIds.
     * @returns 
     */
    counters(folderItemIds?: Array<number>,  __fetchOptions?: RequestOptions): Promise<Array<FolderCounters>>;
    /**
     * @param value the folder to create
     * @returns the identifier allocated in the subtree container
     */
    createBasic(value?: MailboxFolder,  __fetchOptions?: RequestOptions): Promise<ItemIdentifier>;
    /**
     * @param value the folder to create
     * @returns the identifier allocated in the subtree container
     */
    createForHierarchy(hierarchyId: number, value?: MailboxFolder,  __fetchOptions?: RequestOptions): Promise<ItemIdentifier>;
    /**
     * Also delete all known child folders.
     * @param id the folder identifier
     */
    deepDelete(id: number,  __fetchOptions?: RequestOptions): Promise<void>;
    deleteById(id: number,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Empty an email folder including child folders.
     * @param id the folder identifier
     */
    emptyFolder(id: number,  __fetchOptions?: RequestOptions): Promise<void>;
    filteredChangesetById(since?: number, arg1?: ItemFlagFilter,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<ItemVersion>>;
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<MailboxFolder>>;
    getCompleteById(id: number,  __fetchOptions?: RequestOptions): Promise<ItemValue<MailboxFolder>>;
    getFullName(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
    getVersion( __fetchOptions?: RequestOptions): Promise<number>;
    /**
     * Import MailboxItems from a source folder describe
     * {@link ImportMailboxItemSet#mailboxFolderId}
     * 
     * Source and destination folders must be in the same subtree
     */
    importItems(folderDestinationId: number, mailboxItems?: ImportMailboxItemSet,  __fetchOptions?: RequestOptions): Promise<ImportMailboxItemsStatus>;
    itemChangelog(uid: string, arg1?: number,  __fetchOptions?: RequestOptions): Promise<ItemChangelog>;
    /**
     * Mark folder as read (does not include sub-folders).
     * @param id the folder identifier
     */
    markFolderAsRead(id: number,  __fetchOptions?: RequestOptions): Promise<void>;
    multipleGetById(arg0?: Array<number>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<MailboxFolder>>>;
    /**
     * Empty an email folder keeping child folders.
     * @param id the folder identifier
     */
    removeMessages(id: number,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * @returns INBOX for user mailboxes or the toplevel mailshare folder
     */
    root( __fetchOptions?: RequestOptions): Promise<ItemValue<MailboxFolder>>;
    searchItems(query?: MailboxFolderSearchQuery,  __fetchOptions?: RequestOptions): Promise<SearchResult>;
    trash( __fetchOptions?: RequestOptions): Promise<ItemValue<MailboxFolder>>;
    updateById(id: number, value?: MailboxFolder,  __fetchOptions?: RequestOptions): Promise<Ack>;
}

export declare class MailboxFoldersByOwnerClient extends ApiEndPoint implements IMailboxFoldersByOwner {
    domainUid: string;
    ownerUid: string;
    constructor(apiKey: string, domainUid: string, ownerUid: string, base?: string);
    all( __fetchOptions?: RequestOptions): Promise<Array<ItemValue<MailboxFolder>>>;
    byName(name: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<MailboxFolder>>;
    changeset(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<string>>;
    changesetById(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<number>>;
    childrensOf(folderUid: string,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<MailboxFolder>>>;
    counters(folderItemIds?: Array<number>,  __fetchOptions?: RequestOptions): Promise<Array<FolderCounters>>;
    createBasic(value?: MailboxFolder,  __fetchOptions?: RequestOptions): Promise<ItemIdentifier>;
    createForHierarchy(hierarchyId: number, value?: MailboxFolder,  __fetchOptions?: RequestOptions): Promise<ItemIdentifier>;
    deepDelete(id: number,  __fetchOptions?: RequestOptions): Promise<void>;
    deleteById(id: number,  __fetchOptions?: RequestOptions): Promise<void>;
    emptyFolder(id: number,  __fetchOptions?: RequestOptions): Promise<void>;
    filteredChangesetById(since?: number, arg1?: ItemFlagFilter,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<ItemVersion>>;
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<MailboxFolder>>;
    getCompleteById(id: number,  __fetchOptions?: RequestOptions): Promise<ItemValue<MailboxFolder>>;
    getFullName(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
    getVersion( __fetchOptions?: RequestOptions): Promise<number>;
    importItems(folderDestinationId: number, mailboxItems?: ImportMailboxItemSet,  __fetchOptions?: RequestOptions): Promise<ImportMailboxItemsStatus>;
    itemChangelog(uid: string, arg1?: number,  __fetchOptions?: RequestOptions): Promise<ItemChangelog>;
    markFolderAsRead(id: number,  __fetchOptions?: RequestOptions): Promise<void>;
    multipleGetById(arg0?: Array<number>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<MailboxFolder>>>;
    removeMessages(id: number,  __fetchOptions?: RequestOptions): Promise<void>;
    root( __fetchOptions?: RequestOptions): Promise<ItemValue<MailboxFolder>>;
    searchItems(query?: MailboxFolderSearchQuery,  __fetchOptions?: RequestOptions): Promise<SearchResult>;
    trash( __fetchOptions?: RequestOptions): Promise<ItemValue<MailboxFolder>>;
    updateById(id: number, value?: MailboxFolder,  __fetchOptions?: RequestOptions): Promise<Ack>;
    getMetadata(): EndPointMetadata;
}
