
import { VCardInfo } from "./VCardInfo"; 
import { CertInfo } from "./CertInfo"; 
import { VCardQuery } from "./VCardQuery"; 
import { 
    ItemContainerValue
} from "@bluemind/core.container.api";
import { 
    ListResult
} from "@bluemind/core.foldershare.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface IAddressBooks {
    /**
     * Look up certificates for the given email in all subscribed addressbooks
     * 
     * This operation is suitable to look up usable smime certs to encrypt a message
     * for a recipient.
     */
    findCertsByEmail(email?: string,  __fetchOptions?: RequestOptions): Promise<Array<CertInfo>>;
    /**
     * 
     * @returns a list of itemId as strings
     */
    findUidsByEmail(email?: string,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    /**
     * ElasticSearch based vcard search througth all subscribed addressbooks
     */
    search(query?: VCardQuery,  __fetchOptions?: RequestOptions): Promise<ListResult<ItemContainerValue<VCardInfo>>>;
}

export declare class AddressBooksClient extends ApiEndPoint implements IAddressBooks {
    constructor(apiKey: string, base?: string);
    findCertsByEmail(email?: string,  __fetchOptions?: RequestOptions): Promise<Array<CertInfo>>;
    findUidsByEmail(email?: string,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    search(query?: VCardQuery,  __fetchOptions?: RequestOptions): Promise<ListResult<ItemContainerValue<VCardInfo>>>;
    getMetadata(): EndPointMetadata;
}
