/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.icalendar.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ICalendarElementGwtSerDer implements GwtSerDer<net.bluemind.icalendar.api.ICalendarElement> {

	public ICalendarElementGwtSerDer( ) {
	}

	@Override
	public net.bluemind.icalendar.api.ICalendarElement deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.icalendar.api.ICalendarElement ret = new net.bluemind.icalendar.api.ICalendarElement();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.icalendar.api.ICalendarElement ret, JSONObject json) {
		JSONValue dtstartJSON = json.get("dtstart");
		ret.dtstart =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(dtstartJSON);
		JSONValue summaryJSON = json.get("summary");
		ret.summary =  GwtSerDerUtils.STRING.deserialize(summaryJSON);
		JSONValue classificationJSON = json.get("classification");
		ret.classification =  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementClassificationGwtSerDer().deserialize(classificationJSON);
		JSONValue locationJSON = json.get("location");
		ret.location =  GwtSerDerUtils.STRING.deserialize(locationJSON);
		JSONValue descriptionJSON = json.get("description");
		ret.description =  GwtSerDerUtils.STRING.deserialize(descriptionJSON);
		JSONValue priorityJSON = json.get("priority");
		ret.priority =  GwtSerDerUtils.INT.deserialize(priorityJSON);
		JSONValue alarmJSON = json.get("alarm");
		ret.alarm =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.icalendar.api.gwt.serder.ICalendarElementVAlarmGwtSerDer()).deserialize(alarmJSON);
		JSONValue statusJSON = json.get("status");
		ret.status =  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementStatusGwtSerDer().deserialize(statusJSON);
		JSONValue attendeesJSON = json.get("attendees");
		ret.attendees =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.icalendar.api.gwt.serder.ICalendarElementAttendeeGwtSerDer()).deserialize(attendeesJSON);
		JSONValue organizerJSON = json.get("organizer");
		ret.organizer =  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementOrganizerGwtSerDer().deserialize(organizerJSON);
		JSONValue categoriesJSON = json.get("categories");
		ret.categories =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.tag.api.gwt.serder.TagRefGwtSerDer()).deserialize(categoriesJSON);
		JSONValue exdateJSON = json.get("exdate");
		ret.exdate =  new GwtSerDerUtils.SetSerDer<>(new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer()).deserialize(exdateJSON);
		JSONValue rdateJSON = json.get("rdate");
		ret.rdate =  new GwtSerDerUtils.SetSerDer<>(new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer()).deserialize(rdateJSON);
		JSONValue rruleJSON = json.get("rrule");
		ret.rrule =  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementRRuleGwtSerDer().deserialize(rruleJSON);
		JSONValue urlJSON = json.get("url");
		ret.url =  GwtSerDerUtils.STRING.deserialize(urlJSON);
		JSONValue conferenceJSON = json.get("conference");
		ret.conference =  GwtSerDerUtils.STRING.deserialize(conferenceJSON);
		JSONValue conferenceIdJSON = json.get("conferenceId");
		ret.conferenceId =  GwtSerDerUtils.STRING.deserialize(conferenceIdJSON);
		JSONValue conferenceConfigurationJSON = json.get("conferenceConfiguration");
		ret.conferenceConfiguration =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(conferenceConfigurationJSON);
		JSONValue attachmentsJSON = json.get("attachments");
		ret.attachments =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.attachment.api.gwt.serder.AttachedFileGwtSerDer()).deserialize(attachmentsJSON);
		JSONValue propertiesJSON = json.get("properties");
		ret.properties =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(propertiesJSON);
		JSONValue sequenceJSON = json.get("sequence");
		ret.sequence =  GwtSerDerUtils.INT.deserialize(sequenceJSON);
		JSONValue draftJSON = json.get("draft");
		ret.draft =  GwtSerDerUtils.BOOLEAN.deserialize(draftJSON);
	}

	public void deserializeTo(net.bluemind.icalendar.api.ICalendarElement ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("dtstart")) {
			JSONValue dtstartJSON = json.get("dtstart");
			ret.dtstart =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(dtstartJSON);
		}
		if (!childPropertiesToIgnore.contains("summary")) {
			JSONValue summaryJSON = json.get("summary");
			ret.summary =  GwtSerDerUtils.STRING.deserialize(summaryJSON);
		}
		if (!childPropertiesToIgnore.contains("classification")) {
			JSONValue classificationJSON = json.get("classification");
			ret.classification =  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementClassificationGwtSerDer().deserialize(classificationJSON);
		}
		if (!childPropertiesToIgnore.contains("location")) {
			JSONValue locationJSON = json.get("location");
			ret.location =  GwtSerDerUtils.STRING.deserialize(locationJSON);
		}
		if (!childPropertiesToIgnore.contains("description")) {
			JSONValue descriptionJSON = json.get("description");
			ret.description =  GwtSerDerUtils.STRING.deserialize(descriptionJSON);
		}
		if (!childPropertiesToIgnore.contains("priority")) {
			JSONValue priorityJSON = json.get("priority");
			ret.priority =  GwtSerDerUtils.INT.deserialize(priorityJSON);
		}
		if (!childPropertiesToIgnore.contains("alarm")) {
			JSONValue alarmJSON = json.get("alarm");
			ret.alarm =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.icalendar.api.gwt.serder.ICalendarElementVAlarmGwtSerDer()).deserialize(alarmJSON);
		}
		if (!childPropertiesToIgnore.contains("status")) {
			JSONValue statusJSON = json.get("status");
			ret.status =  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementStatusGwtSerDer().deserialize(statusJSON);
		}
		if (!childPropertiesToIgnore.contains("attendees")) {
			JSONValue attendeesJSON = json.get("attendees");
			ret.attendees =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.icalendar.api.gwt.serder.ICalendarElementAttendeeGwtSerDer()).deserialize(attendeesJSON);
		}
		if (!childPropertiesToIgnore.contains("organizer")) {
			JSONValue organizerJSON = json.get("organizer");
			ret.organizer =  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementOrganizerGwtSerDer().deserialize(organizerJSON);
		}
		if (!childPropertiesToIgnore.contains("categories")) {
			JSONValue categoriesJSON = json.get("categories");
			ret.categories =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.tag.api.gwt.serder.TagRefGwtSerDer()).deserialize(categoriesJSON);
		}
		if (!childPropertiesToIgnore.contains("exdate")) {
			JSONValue exdateJSON = json.get("exdate");
			ret.exdate =  new GwtSerDerUtils.SetSerDer<>(new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer()).deserialize(exdateJSON);
		}
		if (!childPropertiesToIgnore.contains("rdate")) {
			JSONValue rdateJSON = json.get("rdate");
			ret.rdate =  new GwtSerDerUtils.SetSerDer<>(new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer()).deserialize(rdateJSON);
		}
		if (!childPropertiesToIgnore.contains("rrule")) {
			JSONValue rruleJSON = json.get("rrule");
			ret.rrule =  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementRRuleGwtSerDer().deserialize(rruleJSON);
		}
		if (!childPropertiesToIgnore.contains("url")) {
			JSONValue urlJSON = json.get("url");
			ret.url =  GwtSerDerUtils.STRING.deserialize(urlJSON);
		}
		if (!childPropertiesToIgnore.contains("conference")) {
			JSONValue conferenceJSON = json.get("conference");
			ret.conference =  GwtSerDerUtils.STRING.deserialize(conferenceJSON);
		}
		if (!childPropertiesToIgnore.contains("conferenceId")) {
			JSONValue conferenceIdJSON = json.get("conferenceId");
			ret.conferenceId =  GwtSerDerUtils.STRING.deserialize(conferenceIdJSON);
		}
		if (!childPropertiesToIgnore.contains("conferenceConfiguration")) {
			JSONValue conferenceConfigurationJSON = json.get("conferenceConfiguration");
			ret.conferenceConfiguration =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(conferenceConfigurationJSON);
		}
		if (!childPropertiesToIgnore.contains("attachments")) {
			JSONValue attachmentsJSON = json.get("attachments");
			ret.attachments =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.attachment.api.gwt.serder.AttachedFileGwtSerDer()).deserialize(attachmentsJSON);
		}
		if (!childPropertiesToIgnore.contains("properties")) {
			JSONValue propertiesJSON = json.get("properties");
			ret.properties =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(propertiesJSON);
		}
		if (!childPropertiesToIgnore.contains("sequence")) {
			JSONValue sequenceJSON = json.get("sequence");
			ret.sequence =  GwtSerDerUtils.INT.deserialize(sequenceJSON);
		}
		if (!childPropertiesToIgnore.contains("draft")) {
			JSONValue draftJSON = json.get("draft");
			ret.draft =  GwtSerDerUtils.BOOLEAN.deserialize(draftJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.icalendar.api.ICalendarElement o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.icalendar.api.ICalendarElement o, JSONObject ret) {

		ret.put("dtstart",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.dtstart ));
		ret.put("summary",  GwtSerDerUtils.STRING.serialize( o.summary ));
		ret.put("classification",  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementClassificationGwtSerDer().serialize( o.classification ));
		ret.put("location",  GwtSerDerUtils.STRING.serialize( o.location ));
		ret.put("description",  GwtSerDerUtils.STRING.serialize( o.description ));
		ret.put("priority",  GwtSerDerUtils.INT.serialize( o.priority ));
		ret.put("alarm",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.icalendar.api.gwt.serder.ICalendarElementVAlarmGwtSerDer()).serialize( o.alarm ));
		ret.put("status",  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementStatusGwtSerDer().serialize( o.status ));
		ret.put("attendees",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.icalendar.api.gwt.serder.ICalendarElementAttendeeGwtSerDer()).serialize( o.attendees ));
		ret.put("organizer",  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementOrganizerGwtSerDer().serialize( o.organizer ));
		ret.put("categories",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.tag.api.gwt.serder.TagRefGwtSerDer()).serialize( o.categories ));
		ret.put("exdate",  new GwtSerDerUtils.SetSerDer<>(new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer()).serialize( o.exdate ));
		ret.put("rdate",  new GwtSerDerUtils.SetSerDer<>(new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer()).serialize( o.rdate ));
		ret.put("rrule",  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementRRuleGwtSerDer().serialize( o.rrule ));
		ret.put("url",  GwtSerDerUtils.STRING.serialize( o.url ));
		ret.put("conference",  GwtSerDerUtils.STRING.serialize( o.conference ));
		ret.put("conferenceId",  GwtSerDerUtils.STRING.serialize( o.conferenceId ));
		ret.put("conferenceConfiguration",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.conferenceConfiguration ));
		ret.put("attachments",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.attachment.api.gwt.serder.AttachedFileGwtSerDer()).serialize( o.attachments ));
		ret.put("properties",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.properties ));
		ret.put("sequence",  GwtSerDerUtils.INT.serialize( o.sequence ));
		ret.put("draft",  GwtSerDerUtils.BOOLEAN.serialize( o.draft ));
	}

	public void serializeTo(net.bluemind.icalendar.api.ICalendarElement o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("dtstart")) {
			ret.put("dtstart",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.dtstart ));
		}
		if (!childPropertiesToIgnore.contains("summary")) {
			ret.put("summary",  GwtSerDerUtils.STRING.serialize( o.summary ));
		}
		if (!childPropertiesToIgnore.contains("classification")) {
			ret.put("classification",  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementClassificationGwtSerDer().serialize( o.classification ));
		}
		if (!childPropertiesToIgnore.contains("location")) {
			ret.put("location",  GwtSerDerUtils.STRING.serialize( o.location ));
		}
		if (!childPropertiesToIgnore.contains("description")) {
			ret.put("description",  GwtSerDerUtils.STRING.serialize( o.description ));
		}
		if (!childPropertiesToIgnore.contains("priority")) {
			ret.put("priority",  GwtSerDerUtils.INT.serialize( o.priority ));
		}
		if (!childPropertiesToIgnore.contains("alarm")) {
			ret.put("alarm",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.icalendar.api.gwt.serder.ICalendarElementVAlarmGwtSerDer()).serialize( o.alarm ));
		}
		if (!childPropertiesToIgnore.contains("status")) {
			ret.put("status",  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementStatusGwtSerDer().serialize( o.status ));
		}
		if (!childPropertiesToIgnore.contains("attendees")) {
			ret.put("attendees",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.icalendar.api.gwt.serder.ICalendarElementAttendeeGwtSerDer()).serialize( o.attendees ));
		}
		if (!childPropertiesToIgnore.contains("organizer")) {
			ret.put("organizer",  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementOrganizerGwtSerDer().serialize( o.organizer ));
		}
		if (!childPropertiesToIgnore.contains("categories")) {
			ret.put("categories",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.tag.api.gwt.serder.TagRefGwtSerDer()).serialize( o.categories ));
		}
		if (!childPropertiesToIgnore.contains("exdate")) {
			ret.put("exdate",  new GwtSerDerUtils.SetSerDer<>(new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer()).serialize( o.exdate ));
		}
		if (!childPropertiesToIgnore.contains("rdate")) {
			ret.put("rdate",  new GwtSerDerUtils.SetSerDer<>(new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer()).serialize( o.rdate ));
		}
		if (!childPropertiesToIgnore.contains("rrule")) {
			ret.put("rrule",  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementRRuleGwtSerDer().serialize( o.rrule ));
		}
		if (!childPropertiesToIgnore.contains("url")) {
			ret.put("url",  GwtSerDerUtils.STRING.serialize( o.url ));
		}
		if (!childPropertiesToIgnore.contains("conference")) {
			ret.put("conference",  GwtSerDerUtils.STRING.serialize( o.conference ));
		}
		if (!childPropertiesToIgnore.contains("conferenceId")) {
			ret.put("conferenceId",  GwtSerDerUtils.STRING.serialize( o.conferenceId ));
		}
		if (!childPropertiesToIgnore.contains("conferenceConfiguration")) {
			ret.put("conferenceConfiguration",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.conferenceConfiguration ));
		}
		if (!childPropertiesToIgnore.contains("attachments")) {
			ret.put("attachments",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.attachment.api.gwt.serder.AttachedFileGwtSerDer()).serialize( o.attachments ));
		}
		if (!childPropertiesToIgnore.contains("properties")) {
			ret.put("properties",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.properties ));
		}
		if (!childPropertiesToIgnore.contains("sequence")) {
			ret.put("sequence",  GwtSerDerUtils.INT.serialize( o.sequence ));
		}
		if (!childPropertiesToIgnore.contains("draft")) {
			ret.put("draft",  GwtSerDerUtils.BOOLEAN.serialize( o.draft ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}