/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.user.repository;

import java.sql.SQLException;
import java.util.List;

import net.bluemind.core.container.model.Container;

public interface IUserSubscriptionStore {

	void subscribe(String subject, Container container) throws SQLException;

	boolean isSubscribed(String subject, Container container) throws SQLException;

	void unsubscribe(String subject, String containerUid) throws SQLException;

	void unsubscribeAll(String subject) throws SQLException;

	/**
	 * @param subject user uid
	 * @param type    might be null to search all subscriptions
	 * @return a list of container uid the subject is subscribed to
	 * @throws SQLException
	 */
	List<String> listSubscriptions(String subject, String type) throws SQLException;

	public List<String> subscribers(String containerUid) throws SQLException;

	void allowSynchronization(String subject, Container container, boolean sync) throws SQLException;

	boolean isSyncAllowed(String subject, Container container) throws SQLException;

	void updateAutomount(String subject, Container container, boolean automount) throws SQLException;

	boolean isAutomounted(String subject, Container container) throws SQLException;
}
