package net.bluemind.milter;

import java.nio.ByteBuffer;
import java.util.Properties;

import org.apache.james.mime4j.dom.Message;

public interface IMilterListener {
	/**
	 * Called for each message
	 * 
	 * @param envelope
	 * @param message
	 */
	public Status onMessage(Properties properties, SmtpEnvelope envelope, Message message);

	/**
	 * Called to handle the envelope FROM command
	 * 
	 * @param from
	 * @return
	 */
	public Status onEnvFrom(Properties properties, String from);

	/**
	 * Called to handle the envelope RCPT command. One for each RCPT command
	 * 
	 * @param rcpt
	 * @return
	 */
	public Status onEnvRcpt(Properties properties, String rcpt);

	/**
	 * Called to handle message header
	 * 
	 * @param headerf
	 * @param headerv
	 * @return
	 */
	public Status onHeader(String headerf, String headerv);

	/**
	 * Called to handle the end of message headers
	 * 
	 * @return
	 */
	public Status onEoh();

	/**
	 * Called to handle a piece of a message's body
	 * 
	 * @param bodyp
	 * @return
	 */
	public Status onBody(ByteBuffer bodyp);
}
