/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.core.jdbc.persistence;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.jdbc.DbSchemaService;
import net.bluemind.core.jdbc.JdbcActivator;
import net.bluemind.system.repository.IStorageSchemaStore;

public class StorageSchemaStore implements IStorageSchemaStore {

	private static final Logger logger = LoggerFactory.getLogger(StorageSchemaStore.class);

	@Override
	public void initSchemas() {
		try {
			JdbcActivator.getInstance().restartDataSource();
		} catch (Exception e) {
			logger.error("Error during database pool restarting", e);
			throw new ServerFault("Error during database pool restarting: " + e.getMessage());
		}
		DbSchemaService dbSchemaService = DbSchemaService.getService(JdbcActivator.getInstance().getDataSource(), true);
		dbSchemaService.initialize();
	}

}
