<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * DelegationRule.
 */
class DelegationRule  {

  /*
   * @type String
   */
  public $delegatorCalendarUid;

  /*
   * @type List
   */
  public $delegateUids;

  /*
   * @type String
   */
  public $delegatorUid;

  /*
   * @type boolean
   */
  public $keepCopy;

  /*
   * @type boolean
   */
  public $readOnly;

  /*
   * Constructor
   */
  public function __construct() {
    $this->delegatorCalendarUid = "";
    $this->delegateUids =  array();
    $this->delegatorUid = "";
    $this->keepCopy = false;
    $this->readOnly = false;
  }

  public function toMap() {
    $data = array(    
        "delegatorCalendarUid" => empty($this->delegatorCalendarUid) ? null : $this->delegatorCalendarUid,    
        "delegateUids" => empty($this->delegateUids) ? null : $this->delegateUids,    
        "delegatorUid" => empty($this->delegatorUid) ? null : $this->delegatorUid,    
        "keepCopy" => empty($this->keepCopy) ? null : $this->keepCopy,    
        "readOnly" => empty($this->readOnly) ? null : $this->readOnly);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
