/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.dataprotect.notes.impl;

import java.util.List;

import net.bluemind.core.container.model.ContainerDescriptor;
import net.bluemind.core.container.model.ItemValue;
import net.bluemind.dataprotect.common.backup.ListBackupDescriptor;
import net.bluemind.notes.api.VNote;

public class NoteBackupDescriptor {

	public ListBackupDescriptor<VNote> descriptor;

	public NoteBackupDescriptor() {
		super();
	}

	protected NoteBackupDescriptor(ContainerDescriptor container, List<ItemValue<VNote>> items) {
		this.descriptor = new ListBackupDescriptor<>(container, items);
	}

}
