/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.persistence;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.sql.DataSource;

import net.bluemind.core.container.model.ContainerDescriptor;
import net.bluemind.core.container.model.acl.AccessControlEntry;
import net.bluemind.core.container.model.acl.Verb;
import net.bluemind.core.container.repository.ISharedContainerStore;
import net.bluemind.core.jdbc.JdbcAbstractStore;
import net.bluemind.core.rest.BmContext;

public class SharedContainerStore extends JdbcAbstractStore implements ISharedContainerStore {

	public SharedContainerStore(BmContext ctx, DataSource pool) {
		super(pool);
	}

	private static final String MGET_QUERY = """
			SELECT c.uid, c.id, c.container_type, c.name, c.owner, c.domain_uid, subject, verb
			FROM t_container_acl acl INNER JOIN t_container c ON acl.container_id = c.id
			WHERE container_id = ANY (?)
			""";

	public List<SharedContainerStoreResult> mget(final List<Long> uids) throws SQLException {
		Long[] array = uids.toArray(new Long[0]);
		return new ArrayList<>(select(MGET_QUERY,
				rs -> new SharedContainerStoreResult(new ContainerDescriptor(), new AccessControlEntry()),
				Arrays.asList(populator), new Object[] { array }));
	}

	private static final String GET_FOR_SUBJECT_QUERY = """
			SELECT c.uid, c.id, c.container_type, c.name, c.owner, c.domain_uid, subject, verb
			FROM t_container_acl acl INNER JOIN t_container c ON acl.container_id = c.id
			WHERE subject = ?
			""";

	public List<SharedContainerStoreResult> getForSubject(String subject) throws SQLException {
		return new ArrayList<>(select(GET_FOR_SUBJECT_QUERY,
				rs -> new SharedContainerStoreResult(new ContainerDescriptor(), new AccessControlEntry()),
				Arrays.asList(populator), new Object[] { subject }));
	}

	private static final EntityPopulator<SharedContainerStoreResult> populator = (rs, index, value) -> {
		value.desc().uid = rs.getString(index++);
		value.desc().internalId = rs.getLong(index++);
		value.desc().type = rs.getString(index++);
		value.desc().name = rs.getString(index++);
		value.desc().owner = rs.getString(index++);
		value.desc().domainUid = rs.getString(index++);
		value.acl().subject = rs.getString(index++);
		value.acl().verb = Verb.valueOf(rs.getString(index++));
		return index;
	};

	public DataSource getDataSource() {
		return datasource;
	}

}
