/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.notes.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VNoteGwtSerDer implements GwtSerDer<net.bluemind.notes.api.VNote> {

	public VNoteGwtSerDer( ) {
	}

	@Override
	public net.bluemind.notes.api.VNote deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.notes.api.VNote ret = new net.bluemind.notes.api.VNote();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.notes.api.VNote ret, JSONObject json) {
		JSONValue heightJSON = json.get("height");
		ret.height =  GwtSerDerUtils.INT.deserialize(heightJSON);
		JSONValue widthJSON = json.get("width");
		ret.width =  GwtSerDerUtils.INT.deserialize(widthJSON);
		JSONValue posXJSON = json.get("posX");
		ret.posX =  GwtSerDerUtils.INT.deserialize(posXJSON);
		JSONValue posYJSON = json.get("posY");
		ret.posY =  GwtSerDerUtils.INT.deserialize(posYJSON);
		JSONValue colorJSON = json.get("color");
		ret.color =  new net.bluemind.notes.api.gwt.serder.VNoteColorGwtSerDer().deserialize(colorJSON);
		JSONValue bodyJSON = json.get("body");
		ret.body =  GwtSerDerUtils.STRING.deserialize(bodyJSON);
		JSONValue subjectJSON = json.get("subject");
		ret.subject =  GwtSerDerUtils.STRING.deserialize(subjectJSON);
		JSONValue categoriesJSON = json.get("categories");
		ret.categories =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.tag.api.gwt.serder.TagRefGwtSerDer()).deserialize(categoriesJSON);
	}

	public void deserializeTo(net.bluemind.notes.api.VNote ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("height")) {
			JSONValue heightJSON = json.get("height");
			ret.height =  GwtSerDerUtils.INT.deserialize(heightJSON);
		}
		if (!childPropertiesToIgnore.contains("width")) {
			JSONValue widthJSON = json.get("width");
			ret.width =  GwtSerDerUtils.INT.deserialize(widthJSON);
		}
		if (!childPropertiesToIgnore.contains("posX")) {
			JSONValue posXJSON = json.get("posX");
			ret.posX =  GwtSerDerUtils.INT.deserialize(posXJSON);
		}
		if (!childPropertiesToIgnore.contains("posY")) {
			JSONValue posYJSON = json.get("posY");
			ret.posY =  GwtSerDerUtils.INT.deserialize(posYJSON);
		}
		if (!childPropertiesToIgnore.contains("color")) {
			JSONValue colorJSON = json.get("color");
			ret.color =  new net.bluemind.notes.api.gwt.serder.VNoteColorGwtSerDer().deserialize(colorJSON);
		}
		if (!childPropertiesToIgnore.contains("body")) {
			JSONValue bodyJSON = json.get("body");
			ret.body =  GwtSerDerUtils.STRING.deserialize(bodyJSON);
		}
		if (!childPropertiesToIgnore.contains("subject")) {
			JSONValue subjectJSON = json.get("subject");
			ret.subject =  GwtSerDerUtils.STRING.deserialize(subjectJSON);
		}
		if (!childPropertiesToIgnore.contains("categories")) {
			JSONValue categoriesJSON = json.get("categories");
			ret.categories =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.tag.api.gwt.serder.TagRefGwtSerDer()).deserialize(categoriesJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.notes.api.VNote o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.notes.api.VNote o, JSONObject ret) {

		ret.put("height",  GwtSerDerUtils.INT.serialize( o.height ));
		ret.put("width",  GwtSerDerUtils.INT.serialize( o.width ));
		ret.put("posX",  GwtSerDerUtils.INT.serialize( o.posX ));
		ret.put("posY",  GwtSerDerUtils.INT.serialize( o.posY ));
		ret.put("color",  new net.bluemind.notes.api.gwt.serder.VNoteColorGwtSerDer().serialize( o.color ));
		ret.put("body",  GwtSerDerUtils.STRING.serialize( o.body ));
		ret.put("subject",  GwtSerDerUtils.STRING.serialize( o.subject ));
		ret.put("categories",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.tag.api.gwt.serder.TagRefGwtSerDer()).serialize( o.categories ));
	}

	public void serializeTo(net.bluemind.notes.api.VNote o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("height")) {
			ret.put("height",  GwtSerDerUtils.INT.serialize( o.height ));
		}
		if (!childPropertiesToIgnore.contains("width")) {
			ret.put("width",  GwtSerDerUtils.INT.serialize( o.width ));
		}
		if (!childPropertiesToIgnore.contains("posX")) {
			ret.put("posX",  GwtSerDerUtils.INT.serialize( o.posX ));
		}
		if (!childPropertiesToIgnore.contains("posY")) {
			ret.put("posY",  GwtSerDerUtils.INT.serialize( o.posY ));
		}
		if (!childPropertiesToIgnore.contains("color")) {
			ret.put("color",  new net.bluemind.notes.api.gwt.serder.VNoteColorGwtSerDer().serialize( o.color ));
		}
		if (!childPropertiesToIgnore.contains("body")) {
			ret.put("body",  GwtSerDerUtils.STRING.serialize( o.body ));
		}
		if (!childPropertiesToIgnore.contains("subject")) {
			ret.put("subject",  GwtSerDerUtils.STRING.serialize( o.subject ));
		}
		if (!childPropertiesToIgnore.contains("categories")) {
			ret.put("categories",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.tag.api.gwt.serder.TagRefGwtSerDer()).serialize( o.categories ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}