/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.tx.outbox.cql.store;

import net.bluemind.core.api.DataSourceType;
import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.model.DataLocation;
import net.bluemind.core.rest.BmContext;
import net.bluemind.repository.provider.IDataLocationBoundFactory;
import net.bluemind.tx.outbox.repository.ITxOutboxRepository;

public class CqlRepoFactory implements IDataLocationBoundFactory<ITxOutboxRepository> {

	@Override
	public Class<ITxOutboxRepository> factoryClass() {
		return ITxOutboxRepository.class;
	}

	@Override
	public DataSourceType targetRepositoryType() {
		return DataSourceType.CQL;
	}

	@Override
	public ITxOutboxRepository instance(BmContext context, DataLocation dataLocation) throws ServerFault {
		return new TxOutboxCqlStore();
	}

}
