/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2017
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.backend.mail.replica.api;

import java.util.Collections;
import java.util.Date;
import java.util.List;

import net.bluemind.backend.mail.api.MailboxFolder;
import net.bluemind.core.api.BMApi;

@BMApi(version = "3")
public class MailboxReplica extends MailboxFolder {
	public long lastUid;
	public Date lastAppendDate;
	public long uidValidity;
	public String dataLocation;

	@Override
	public String toString() {
		return "MailboxReplica{n=" + name + ", fn=" + fullName + ", parent=" + parentUid + ", lastUid=" + lastUid
				+ ", lastAppendDate=" + lastAppendDate + ", uidValidity=" + uidValidity + ", dataLocation="
				+ dataLocation + ", isVirtualFolder=" + virtualFolder + "}";
	}

	public static MailboxReplica from(MailboxReplica mbox) {
		MailboxReplica newmbox = new MailboxReplica();
		newmbox.name = mbox.name;
		newmbox.fullName = mbox.fullName;
		newmbox.parentUid = mbox.parentUid;
		newmbox.deleted = mbox.deleted;
		newmbox.lastUid = mbox.lastUid;
		newmbox.lastAppendDate = mbox.lastAppendDate;
		newmbox.uidValidity = mbox.uidValidity;
		newmbox.dataLocation = mbox.dataLocation;
		return newmbox;
	}

	@BMApi(version = "3")
	@Deprecated
	/**
	 * Not used anymore, will be ignored
	 */
	public static class Acl {
		public String subject;
		public String rights;
	}

	/**
	 * Not used anymore, will be ignored
	 */
	@Deprecated
	public long highestModSeq;

	/**
	 * Not used anymore, will be ignored
	 */
	@Deprecated
	public long xconvModSeq;

	/**
	 * Not used anymore, will be ignored
	 */
	@Deprecated
	public long recentUid;

	/**
	 * Not used anymore, will be ignored
	 */
	@Deprecated
	public Date recentTime;

	/**
	 * Not used anymore, will be ignored
	 */
	@Deprecated
	public Date pop3LastLogin;

	/**
	 * Not used anymore, will be ignored
	 */
	@Deprecated
	public List<Acl> acls = Collections.emptyList();

	/**
	 * Not used anymore, will be ignored
	 */
	@Deprecated
	public String options;

	/**
	 * Not used anymore, will be ignored
	 */
	@Deprecated
	public long syncCRC;

	/**
	 * Not used anymore, will be ignored
	 */
	@Deprecated
	public String quotaRoot;

}
