/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2026
 *
 * This file is part of Blue Mind. Blue Mind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License)
 * or the CeCILL as published by CeCILL.info (version 2 of the License).
 *
 * There are special exceptions to the terms and conditions of the
 * licenses as they are applied to this program. See LICENSE.txt in
 * the directory of this program distribution.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.lib.elasticsearch.client.transport;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

import co.elastic.clients.transport.http.TransportHttpClient.Node;

public final class NodePool {
	private final List<Node> nodes;
	private final AtomicInteger counter;

	public NodePool(List<Node> nodes) {
		if (nodes == null || nodes.isEmpty()) {
			throw new IllegalArgumentException("Node list cannot be null or empty");
		}
		this.nodes = List.copyOf(nodes);
		this.counter = new AtomicInteger(0);
	}

	public Node next() {
		int index = counter.getAndUpdate(i -> (i + 1) % nodes.size());
		return nodes.get(index);
	}

	public List<Node> nodes() {
		return nodes;
	}

	public int size() {
		return nodes.size();
	}
}
