/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.backend.mail.cql.store.factories;

import com.datastax.oss.driver.api.core.CqlSession;

import net.bluemind.backend.mail.cql.store.CqlMailboxRecordStore;
import net.bluemind.backend.mail.replica.api.IMailReplicaUids;
import net.bluemind.backend.mail.repository.IMailboxRecordStore;
import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.cql.store.CqlContainerStore;
import net.bluemind.core.container.cql.store.CqlItemStore;
import net.bluemind.core.container.model.Container;
import net.bluemind.core.container.model.Item;
import net.bluemind.core.rest.BmContext;
import net.bluemind.cql.CqlSessions;
import net.bluemind.cql.persistence.CqlRepositoryFactory;
import net.bluemind.repository.provider.IBiContainerBoundFactory;
import net.bluemind.repository.sequences.SequenceStores;

public class RecordsFactory extends CqlRepositoryFactory<IMailboxRecordStore>
		implements IBiContainerBoundFactory<IMailboxRecordStore> {

	@Override
	public Class<IMailboxRecordStore> factoryClass() {
		return IMailboxRecordStore.class;
	}

	@Override
	public IMailboxRecordStore instance(BmContext context, Container records, Container subtree) throws ServerFault {
		CqlSession sess = CqlSessions.forKeyspace("core");
		CqlContainerStore conts = new CqlContainerStore(sess, SequenceStores.getDefault(),
				context.getSecurityContext());
		CqlItemStore items = new CqlItemStore(subtree, sess, SequenceStores.getDefault(), context.getSecurityContext());
		Item folderItem = items.get(IMailReplicaUids.uniqueId(records.uid));
		System.err.println("folderItem is " + folderItem);
		return new CqlMailboxRecordStore(sess, conts, subtree, records, folderItem);
	}

}
