/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.backend.mail.cql.store;

import net.bluemind.core.container.model.SortDescriptor;

public class CqlSortStrategy {

	private SortDescriptor sortDesc;

	public CqlSortStrategy(SortDescriptor sortDesc) {
		this.sortDesc = sortDesc;
	}

	public String queryToSort() {
		StringBuilder q = new StringBuilder();
		if (sortDesc.isFilteredOnDeleted()) {
			q.append("SELECT item_id FROM s_deleted_mailbox_record");
			q.append(" WHERE subtree_id=? AND container_id=?");
		} else {
			q.append("SELECT item_id FROM s_mailbox_record_by_");
			q.append(chooseTable());
			q.append(" WHERE subtree_id=? AND container_id=?");
			if (sortDesc.isFilteredOnNotDeletedAndNotSeen()) {
				q.append(" AND unseen=true ALLOW FILTERING");
			}
			if (sortDesc.isFilteredOnNotDeletedAndImportant()) {
				q.append(" AND flagged=true ALLOW FILTERING");
			}
		}
		return q.toString();
	}

	private String chooseTable() {
		return sortDesc.fields.stream().findAny().map(f -> {
			String root = "";
			switch (f.column) {
			case "size":
				root = "size_desc";
				break;
			case "sender":
				root = "sender_desc";
				break;
			case "subject":
				root = "subject_desc";
				break;

			case "internal_date", "date":
			default:
				root = "date_desc";
				break;
			}
			return root;
		}).orElse("date_desc");
	}

}