/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.backend.mail.cql.store;

import java.util.UUID;

import com.datastax.oss.driver.api.core.CqlSession;

import net.bluemind.cql.persistence.CqlAbstractStore;

public class BaseExpungedStore extends CqlAbstractStore {

	public BaseExpungedStore(CqlSession s) {
		super(s);
	}

	protected void baseDelete(long subtreeContId, long recContId, long item) {
		UUID created = unique(
				"SELECT created FROM q_mailbox_record_expunged_by_container WHERE subtree_id=? AND container_id=? AND item_id=?",
				r -> r.getUuid(0), voidPop(), subtreeContId, recContId, item);
		if (created != null) {
			voidCql("DELETE FROM q_mailbox_record_expunged WHERE global_id=20120331 and created=?", created);
		}
		voidCql("DELETE FROM q_mailbox_record_expunged_by_container WHERE subtree_id=? AND container_id=? AND item_id=?",
				subtreeContId, recContId, item);
	}

}
