/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * RPC Client
 */
DeviceClient._rpcClient;

/**
 * URL
 */
DeviceClient._baseUrl;

/**
 * @type {string} userUid
 * @private
 */
DeviceClient.prototype._userUid;

/**
 * @constructor
 */ 
function DeviceClient(base, sid , userUid ) {
  this._rpcClient = Components.classes["@blue-mind.net/rpcclient;1"].getService().wrappedJSObject;
  this._rpcClient.setAuthKey(sid ? sid : null);
  this._baseUrl = base + '/api/devices/{userUid}';
  
  this._userUid = userUid;
  this._baseUrl = this._baseUrl.replace('{userUid}',userUid);
};

DeviceClient.prototype.setAuthKey = function(sid) {
    this._rpcClient.setAuthKey(sid);
};

/*
 *
 */
DeviceClient.prototype.byIdentifier = function( identifier  ) {
  let url = this._baseUrl + "/{identifier}/byIdentifier";

  url = url.replace("{identifier}", identifier);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
DeviceClient.prototype.create = function( uid ,  device  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = device;
  return this._execute(cmd, body);
};

/*
 *
 */
DeviceClient.prototype.delete_ = function( uid  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
DeviceClient.prototype.deleteAll = function() {
  let url = this._baseUrl + "/_deleteAll";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
DeviceClient.prototype.getComplete = function( uid  ) {
  let url = this._baseUrl + "/{uid}/complete";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
DeviceClient.prototype.list = function() {
  let url = this._baseUrl + "/_list";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
DeviceClient.prototype.setPartnership = function( uid  ) {
  let url = this._baseUrl + "/{uid}/_partnership";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
DeviceClient.prototype.unsetPartnership = function( uid  ) {
  let url = this._baseUrl + "/{uid}/_partnership";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
DeviceClient.prototype.unwipe = function( uid  ) {
  let url = this._baseUrl + "/_unwipe/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
DeviceClient.prototype.update = function( uid ,  device  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = device;
  return this._execute(cmd, body);
};

/*
 *
 */
DeviceClient.prototype.updateLastSync = function( uid  ) {
  let url = this._baseUrl + "/{uid}/_lastSync";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
DeviceClient.prototype.wipe = function( uid ,  mode  ) {
  let url = this._baseUrl + "/_wipe/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = mode;
  return this._execute(cmd, body);
};

DeviceClient.prototype._execute = function(cmd, data) {
  cmd.getData = function() {
    if (data != null){
      return JSON.stringify(data);
    } 
    return null;
  };

  cmd.onSuccess = function(xhr) {
    let contentType = xhr.getResponseHeader("content-type");
    if (contentType == "application/json" && xhr.responseText) {
      cmd.resolve(JSON.parse(xhr.responseText));
    } else {
      cmd.resolve(xhr.response);
    }
  };

  cmd.onFailure = function(xhr) {
    let resp = xhr.response;
    if (resp != null) {
        cmd.reject(resp);
    } else {
        cmd.reject(xhr.status);
    }
  };

  let self = this;
  let result = new Promise(function(resolve, reject) {
    try {
      cmd.resolve = resolve;
      cmd.reject = reject;
      self._rpcClient.execute(cmd);
    } catch(e) {
      reject(e);
    }
  });
  return result;
}
