/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.eas.store;

import java.util.Map;
import java.util.Optional;

import net.bluemind.eas.api.Account;
import net.bluemind.eas.api.FolderSyncVersions;
import net.bluemind.eas.backend.HierarchyNode;
import net.bluemind.eas.backend.MailFolder;
import net.bluemind.eas.backend.MailboxVacation;
import net.bluemind.eas.backend.dto.CollectionIdContext;
import net.bluemind.eas.backend.importer.HierarchyImportFolderUpdateEntity;
import net.bluemind.eas.dto.base.CollectionItem;
import net.bluemind.eas.dto.device.DeviceId;
import net.bluemind.eas.dto.settings.SettingsRequest.Oof;
import net.bluemind.eas.dto.sync.CollectionId;
import net.bluemind.eas.exception.CollectionNotFoundException;
import net.bluemind.eas.exception.ServerErrorException;
import net.bluemind.eas.session.BackendSession;

public interface ISyncStorage {

	long findLastHeartbeat(DeviceId deviceId);

	void updateLastHearbeat(DeviceId deviceId, long hearbeat);

	/**
	 * Update device lastSync
	 * 
	 * @param bs
	 */
	void updateLastSync(BackendSession bs);

	/**
	 * Fetches the value of an EAS system conf.
	 * 
	 * @param key
	 * @return the value or null if no value is defined
	 */
	String getSystemConf(String key);

	Map<String, String> getSystemConf();

	/**
	 * @return
	 */
	Map<String, String> getWipedDevices();

	// Folder

	HierarchyNode getHierarchyNode(String origin, String domainUid, String userUid, String nodeUid)
			throws CollectionNotFoundException;

	HierarchyNode getHierarchyNode(CollectionIdContext collectionIdContext) throws CollectionNotFoundException;

	MailFolder getMailFolder(CollectionIdContext collectionIdContext) throws CollectionNotFoundException;

	MailFolder getMailFolderByName(BackendSession bs, String name) throws CollectionNotFoundException;

	/**
	 * Create + autosubscription
	 * 
	 * @param bs
	 * @param folderName
	 * @return
	 */
	CollectionId createFolder(HierarchyImportFolderUpdateEntity hierarchyEntityrarchyEntity);

	boolean deleteFolder(HierarchyImportFolderUpdateEntity hierarchyEntityrarchyEntity);

	boolean updateFolder(HierarchyImportFolderUpdateEntity hierarchyEntityrarchyEntity);

	// Reset
	boolean needReset(BackendSession bs);

	void resetFolder(BackendSession bs);

	/**
	 * Saves the client used by SendMail to identity resends
	 * 
	 * @param clientId
	 */
	void insertClientId(String clientId);

	/**
	 * Returns true if the clientId is known and the email must not be sent by the
	 * SendMail command
	 * 
	 * @param clientId
	 * @return
	 */
	boolean isKnownClientId(String clientId);

	// Folder Sync
	public void setFolderSyncVersions(FolderSyncVersions versions);

	public Map<String, String> getFolderSyncVersions(Account account);

	public boolean userHasWriteAccess(BackendSession bs, String mboxRecordContainerUid);

	public MailboxVacation getVacationForMailbox(BackendSession bs);

	public void setVacationForMailbox(BackendSession bs, Oof.Set set) throws ServerErrorException;

	long createEphemeralLongId(CollectionItem item);

	Optional<CollectionItem> fromEphemeralLongId(long l);

}
