/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2025
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.eas.data;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

import net.bluemind.eas.backend.IBackend;
import net.bluemind.eas.session.BackendSession;

public class FoldersStuckInSync {

	private static final Map<String, Set<String>> foldersStuckInSynchro = new ConcurrentHashMap<>();

	public static Set<String> getFolders(String devId) {
		return Optional.ofNullable(foldersStuckInSynchro.remove(devId)).orElse(Collections.emptySet());
	}

	public static void addFolder(IBackend backend, BackendSession bs, String collectionId) {
		foldersStuckInSynchro.computeIfAbsent(bs.getDevId(), k -> new HashSet<>()).add(collectionId);
		backend.touchOnMailbox(bs);
	}
}
