/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.eas.backend.importer;

import java.util.Date;
import java.util.Optional;

import net.bluemind.eas.backend.IApplicationData;
import net.bluemind.eas.backend.dto.CollectionIdContext;
import net.bluemind.eas.dto.sync.CollectionId;
import net.bluemind.eas.dto.sync.CollectionSyncRequest.Options.ConflicResolution;
import net.bluemind.eas.dto.sync.SyncState;
import net.bluemind.eas.dto.type.ItemDataType;
import net.bluemind.eas.session.BackendSession;

public class ContentImportEntityForChange extends ContentImportEntity {

	public CollectionId collectionId;
	public Optional<String> serverId;
	public Optional<Date> recurId;
	public IApplicationData data;
	public ConflicResolution conflictPolicy;
	public SyncState syncState;
	public CollectionIdContext collectionIdContext;

	public ContentImportEntityForChange(BackendSession backendSession, ItemDataType type) {
		super(backendSession, type);
	}

	private ContentImportEntityForChange(BackendSession backendSession, CollectionId collectionId, ItemDataType type,
			IApplicationData data, ConflicResolution conflictPolicy, SyncState syncState) {
		super(backendSession, type);
		this.collectionIdContext = new CollectionIdContext(backendSession, collectionId);
		this.collectionId = this.collectionIdContext.collectionId();
		this.data = data;
		this.conflictPolicy = conflictPolicy;
		this.syncState = syncState;
	}

	public static ContentImportEntityForChange create(BackendSession backendSession, CollectionId collectionId, ItemDataType type,
			Optional<String> serverId, Optional<Date> recurId, IApplicationData data, ConflicResolution conflictPolicy,
			SyncState syncState) {
		ContentImportEntityForChange contentEntity = new ContentImportEntityForChange(backendSession, collectionId, type, data,
				conflictPolicy, syncState);
		contentEntity.serverId = serverId;
		contentEntity.recurId = recurId;
		return contentEntity;
	}

	public static ContentImportEntityForChange create(BackendSession backendSession, CollectionId collectionId, ItemDataType type,
			IApplicationData data, ConflicResolution conflictPolicy, SyncState syncState) {
		ContentImportEntityForChange contentEntity = new ContentImportEntityForChange(backendSession, collectionId, type, data,
				conflictPolicy, syncState);
		contentEntity.serverId = Optional.empty();
		contentEntity.recurId = Optional.empty();
		return contentEntity;
	}

	public static ContentImportEntityForChange create(BackendSession backendSession, String serverId, IApplicationData data) {
		ContentImportEntityForChange contentEntity = new ContentImportEntityForChange(backendSession, ItemDataType.EMAIL);
		contentEntity.collectionId = null;
		contentEntity.collectionIdContext = new CollectionIdContext(backendSession, null);
		contentEntity.serverId = Optional.ofNullable(serverId);
		contentEntity.recurId = Optional.empty();
		contentEntity.data = data;
		contentEntity.conflictPolicy = ConflicResolution.SERVER_WINS;
		contentEntity.syncState = null;
		return contentEntity;
	}

}
