/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.user.cql.store;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

import com.datastax.oss.driver.api.core.CqlSession;

import net.bluemind.core.container.model.Container;
import net.bluemind.core.container.model.Item;
import net.bluemind.cql.persistence.CqlAbstractStore;
import net.bluemind.user.api.UserSettings;
import net.bluemind.user.repository.IUserSettingsStore;

public class CqlUserSettingsStore extends CqlAbstractStore implements IUserSettingsStore {

	private long contId;

	public CqlUserSettingsStore(CqlSession s, Container dir) {
		super(s);
		this.contId = dir.id;
	}

	@Override
	public void create(Item item, UserSettings value) throws SQLException {
		update(item, value);
	}

	@Override
	public void update(Item item, UserSettings value) throws SQLException {
		voidCql("update t_dir_entry set settings=? where container_id=? and item_id=?", value.values, contId, item.id);
	}

	@Override
	public void delete(Item item) throws SQLException {
		// fine
	}

	@Override
	public UserSettings get(Item item) throws SQLException {
		Map<String, String> values = unique("select settings from t_dir_entry where container_id=? and item_id=?",
				r -> r.getMap(0, String.class, String.class), voidPop(), contId, item.id);
		return UserSettings.of(Optional.ofNullable(values).orElseGet(Collections::emptyMap));
	}

	@Override
	public void deleteAll() throws SQLException {
		// fine
	}

	@Override
	public boolean exists(Item item) throws SQLException {
		return true;
	}

}
