/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.dataprotect.mailbox.mailshare;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.bluemind.core.container.model.ItemValue;
import net.bluemind.core.context.SecurityContext;
import net.bluemind.core.rest.BmContext;
import net.bluemind.core.rest.IServiceProvider;
import net.bluemind.dataprotect.api.DPError;
import net.bluemind.dataprotect.api.DataProtectGeneration;
import net.bluemind.dataprotect.common.restore.IMonitoredRestoreRestorableItem;
import net.bluemind.dataprotect.service.BackupDataProvider;
import net.bluemind.mailshare.api.IMailshare;
import net.bluemind.mailshare.api.Mailshare;

public class RestoreMailshareTaskPg {

	private static final Logger logger = LoggerFactory.getLogger(RestoreMailshareTaskPg.class);
	private final DataProtectGeneration backup;
	private IMonitoredRestoreRestorableItem restorableItem;
	private final MailshareRestoreWorker mailshareWorker;

	/**
	 * @deprecated REMOVE THIS IN BlueMind 6+
	 */
	@Deprecated
	public RestoreMailshareTaskPg(DataProtectGeneration backup, IMonitoredRestoreRestorableItem item,
			MailshareRestoreWorker mailshareWorker) {
		this.backup = backup;
		this.restorableItem = item;
		this.mailshareWorker = mailshareWorker;
	}

	public void run() {
		logger.info("Restoring mailshare {}:{}", restorableItem.entryUid(), restorableItem.displayName());

		try (BackupDataProvider bdp = new BackupDataProvider(null, SecurityContext.SYSTEM,
				restorableItem.getMonitor())) {
			BmContext backupContext = bdp.createContextWithData(backup, restorableItem.item());
			IServiceProvider back = backupContext.provider();

			IMailshare mailshareServiceLive = back.instance(IMailshare.class, restorableItem.domain());
			ItemValue<Mailshare> backupMailshare = mailshareServiceLive.getComplete(restorableItem.entryUid());

			ItemValue<Mailshare> liveMailshare = mailshareWorker.createOrUpdateLiveEntry(backupMailshare);
			restorableItem.setLiveEntryUid(liveMailshare.uid);
			mailshareWorker.restoreMailbox();

		} catch (Exception e) {
			logger.error("Error while restoring mailshare {}:{}@{}: {}", restorableItem.entryUid(), 
					restorableItem.displayName(), restorableItem.domain(), e.getMessage());
			restorableItem.errors()
					.add(DPError.restore(e.getMessage(), restorableItem.entryUid(), DPError.DPKind.MAILSHARE));
		} finally {
			restorableItem.endTask();
		}
	}

}
