/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class DomainTemplateDescriptionGwtSerDer implements GwtSerDer<net.bluemind.system.api.DomainTemplate.Description> {

	public DomainTemplateDescriptionGwtSerDer( ) {
	}

	@Override
	public net.bluemind.system.api.DomainTemplate.Description deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.system.api.DomainTemplate.Description ret = new net.bluemind.system.api.DomainTemplate.Description();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.system.api.DomainTemplate.Description ret, JSONObject json) {
		JSONValue i18nJSON = json.get("i18n");
		ret.i18n =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.gwt.serder.DomainTemplateDescriptionI18NDescriptionGwtSerDer()).deserialize(i18nJSON);
	}

	public void deserializeTo(net.bluemind.system.api.DomainTemplate.Description ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("i18n")) {
			JSONValue i18nJSON = json.get("i18n");
			ret.i18n =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.gwt.serder.DomainTemplateDescriptionI18NDescriptionGwtSerDer()).deserialize(i18nJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.system.api.DomainTemplate.Description o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.system.api.DomainTemplate.Description o, JSONObject ret) {

		ret.put("i18n",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.gwt.serder.DomainTemplateDescriptionI18NDescriptionGwtSerDer()).serialize( o.i18n ));
	}

	public void serializeTo(net.bluemind.system.api.DomainTemplate.Description o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("i18n")) {
			ret.put("i18n",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.gwt.serder.DomainTemplateDescriptionI18NDescriptionGwtSerDer()).serialize( o.i18n ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}