/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class CloneConfigurationGwtSerDer implements GwtSerDer<net.bluemind.system.api.CloneConfiguration> {

	public CloneConfigurationGwtSerDer( ) {
	}

	@Override
	public net.bluemind.system.api.CloneConfiguration deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.system.api.CloneConfiguration ret = new net.bluemind.system.api.CloneConfiguration();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.system.api.CloneConfiguration ret, JSONObject json) {
		JSONValue sourceInstallationIdJSON = json.get("sourceInstallationId");
		ret.sourceInstallationId =  GwtSerDerUtils.STRING.deserialize(sourceInstallationIdJSON);
		JSONValue uidToIpMappingJSON = json.get("uidToIpMapping");
		ret.uidToIpMapping =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(uidToIpMappingJSON);
		JSONValue sysconfOverrideJSON = json.get("sysconfOverride");
		ret.sysconfOverride =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(sysconfOverrideJSON);
		JSONValue modeJSON = json.get("mode");
		ret.mode =  new net.bluemind.system.api.gwt.serder.CloneConfigurationModeGwtSerDer().deserialize(modeJSON);
		JSONValue cloneWorkersJSON = json.get("cloneWorkers");
		ret.cloneWorkers =  GwtSerDerUtils.INT.deserialize(cloneWorkersJSON);
		JSONValue skippedContainerTypesJSON = json.get("skippedContainerTypes");
		ret.skippedContainerTypes =  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).deserialize(skippedContainerTypesJSON);
	}

	public void deserializeTo(net.bluemind.system.api.CloneConfiguration ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("sourceInstallationId")) {
			JSONValue sourceInstallationIdJSON = json.get("sourceInstallationId");
			ret.sourceInstallationId =  GwtSerDerUtils.STRING.deserialize(sourceInstallationIdJSON);
		}
		if (!childPropertiesToIgnore.contains("uidToIpMapping")) {
			JSONValue uidToIpMappingJSON = json.get("uidToIpMapping");
			ret.uidToIpMapping =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(uidToIpMappingJSON);
		}
		if (!childPropertiesToIgnore.contains("sysconfOverride")) {
			JSONValue sysconfOverrideJSON = json.get("sysconfOverride");
			ret.sysconfOverride =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(sysconfOverrideJSON);
		}
		if (!childPropertiesToIgnore.contains("mode")) {
			JSONValue modeJSON = json.get("mode");
			ret.mode =  new net.bluemind.system.api.gwt.serder.CloneConfigurationModeGwtSerDer().deserialize(modeJSON);
		}
		if (!childPropertiesToIgnore.contains("cloneWorkers")) {
			JSONValue cloneWorkersJSON = json.get("cloneWorkers");
			ret.cloneWorkers =  GwtSerDerUtils.INT.deserialize(cloneWorkersJSON);
		}
		if (!childPropertiesToIgnore.contains("skippedContainerTypes")) {
			JSONValue skippedContainerTypesJSON = json.get("skippedContainerTypes");
			ret.skippedContainerTypes =  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).deserialize(skippedContainerTypesJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.system.api.CloneConfiguration o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.system.api.CloneConfiguration o, JSONObject ret) {

		ret.put("sourceInstallationId",  GwtSerDerUtils.STRING.serialize( o.sourceInstallationId ));
		ret.put("uidToIpMapping",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.uidToIpMapping ));
		ret.put("sysconfOverride",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.sysconfOverride ));
		ret.put("mode",  new net.bluemind.system.api.gwt.serder.CloneConfigurationModeGwtSerDer().serialize( o.mode ));
		ret.put("cloneWorkers",  GwtSerDerUtils.INT.serialize( o.cloneWorkers ));
		ret.put("skippedContainerTypes",  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).serialize( o.skippedContainerTypes ));
	}

	public void serializeTo(net.bluemind.system.api.CloneConfiguration o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("sourceInstallationId")) {
			ret.put("sourceInstallationId",  GwtSerDerUtils.STRING.serialize( o.sourceInstallationId ));
		}
		if (!childPropertiesToIgnore.contains("uidToIpMapping")) {
			ret.put("uidToIpMapping",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.uidToIpMapping ));
		}
		if (!childPropertiesToIgnore.contains("sysconfOverride")) {
			ret.put("sysconfOverride",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.sysconfOverride ));
		}
		if (!childPropertiesToIgnore.contains("mode")) {
			ret.put("mode",  new net.bluemind.system.api.gwt.serder.CloneConfigurationModeGwtSerDer().serialize( o.mode ));
		}
		if (!childPropertiesToIgnore.contains("cloneWorkers")) {
			ret.put("cloneWorkers",  GwtSerDerUtils.INT.serialize( o.cloneWorkers ));
		}
		if (!childPropertiesToIgnore.contains("skippedContainerTypes")) {
			ret.put("skippedContainerTypes",  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).serialize( o.skippedContainerTypes ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}