/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.system.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsUpgradeStatusState extends JavaScriptObject {

	protected JsUpgradeStatusState() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsUpgradeStatusState UPGRADERS_NOT_AVAILABLE()
	/*-{
		return "UPGRADERS_NOT_AVAILABLE";
	}-*/;

	public static final native JsUpgradeStatusState UPGRADERS_NOT_RUNNABLE()
	/*-{
		return "UPGRADERS_NOT_RUNNABLE";
	}-*/;

	public static final native JsUpgradeStatusState OK()
	/*-{
		return "OK";
	}-*/;

	public static final JsUpgradeStatusState create(net.bluemind.system.api.UpgradeStatus.State value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case UPGRADERS_NOT_AVAILABLE:
				return UPGRADERS_NOT_AVAILABLE();
			case UPGRADERS_NOT_RUNNABLE:
				return UPGRADERS_NOT_RUNNABLE();
			case OK:
				return OK();
			default:
				return null;
			}
		}
	}
}