/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.system.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsExternalSystemAuthKind extends JavaScriptObject {

	protected JsExternalSystemAuthKind() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsExternalSystemAuthKind NONE()
	/*-{
		return "NONE";
	}-*/;

	public static final native JsExternalSystemAuthKind SIMPLE_CREDENTIALS()
	/*-{
		return "SIMPLE_CREDENTIALS";
	}-*/;

	public static final native JsExternalSystemAuthKind API_KEY()
	/*-{
		return "API_KEY";
	}-*/;

	public static final native JsExternalSystemAuthKind OPEN_ID_PKCE()
	/*-{
		return "OPEN_ID_PKCE";
	}-*/;

	public static final JsExternalSystemAuthKind create(net.bluemind.system.api.ExternalSystem.AuthKind value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case NONE:
				return NONE();
			case SIMPLE_CREDENTIALS:
				return SIMPLE_CREDENTIALS();
			case API_KEY:
				return API_KEY();
			case OPEN_ID_PKCE:
				return OPEN_ID_PKCE();
			default:
				return null;
			}
		}
	}
}